package com.liquidnet.service.kylin.constant;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 限购类型枚举
 */
@ApiModel("限购类型枚举")
public enum LimitTypeEnum {

    @ApiModelProperty("演出")
    PERFORMANCE(1, "演出"),

    @ApiModelProperty("票种")
    TICKET(2, "票种"),

    @ApiModelProperty("场次")
    TIME(3, "场次");

    private final int code;
    private final String desc;

    LimitTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static LimitTypeEnum valueOf(int code) {
        for (LimitTypeEnum type : values()) {
            if (type.code == code) {
                return type;
            }
        }
        return null;
    }
}