package com.liquidnet.service.sweet.dto.param.poster;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "SweetStrawberryParam", description = "海报数据")
@Data
public class SweetStrawberryParam implements Serializable {

    private static final long serialVersionUID = 9038992103808199663L;

    @ApiModelProperty(position = 10, required = true, value = "openId", example = "openId")
    @NotBlank(message = "openId不能为空")
    private String openId;

    @ApiModelProperty(position = 10, required = true, value = "unionId", example = "unionId")
    @NotBlank(message = "unionId不能为空")
    private String unionId;

    @ApiModelProperty(position = 10, required = true, value = "nickname", example = "nickname")
    @NotBlank(message = "nickname不能为空")
    private String nickname;

    @ApiModelProperty(position = 10, required = true, value = "cityName", example = "cityName")
    @NotBlank(message = "cityName不能为空")
    private String cityName;

    @ApiModelProperty(position = 10, required = true, value = "cityCode", example = "cityCode")
    @NotBlank(message = "cityCode不能为空")
    private String cityCode;

    @ApiModelProperty(position = 10, required = true, value = "customText", example = "customText")
    @NotBlank(message = "customText不能为空")
    private String customText;

    @Valid
    @ApiModelProperty(value = "阵容列表", example = "[{\"lineupNum\": \"lineup1\",\"musicianId\": 9999,\"musicianName\": \"歌手1\"},\n" +
            " {\"lineupNum\": \"lineup1\",\"musicianId\": 23233,\"musicianName\": \"歌手D\"},\n" +
            " {\"lineupNum\": \"lineup2\",\"musicianId\": 1111,\"musicianName\": \"歌手2\"}]")
    @NotNull(message = "musicianList")
    private List<SweetStrawMusicianParam> musicianList;

    private static final SweetStrawberryParam obj = new SweetStrawberryParam();

    public static SweetStrawberryParam getNew() {
        try {
            return (SweetStrawberryParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetStrawberryParam();
        }
    }
}