package com.liquidnet.client.admin.web.controller.zhengzai.merchant;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantSponsorAppliesAdminService;
import com.liquidnet.service.merchant.dto.param.admin.MerchantSponsorApplyListParam;
import com.liquidnet.service.merchant.entity.MerchantSponsorApplies;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

@Api(tags = "主办申请管理")
@Controller
@RequestMapping("merchant/sponsor/apply")
public class MerchantSponsorAppliesController extends BaseController {

    private final String prefix = "zhengzai/kylin/sponsor";

    @Autowired
    IMerchantSponsorAppliesAdminService merchantSponsorAppliesAdminService;

    @RequiresPermissions("merchant:sponsor:apply:view")
    @GetMapping()
    public String applyList() {
        return prefix + "/applyList";
    }

    @Log(title = "主办申请管理", businessType = BusinessType.LIST)
    @RequiresPermissions("merchant:sponsor:apply:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(MerchantSponsorApplyListParam param) {
        startPage();
        return getDataTable(merchantSponsorAppliesAdminService.list(
                Wrappers.lambdaQuery(MerchantSponsorApplies.class)
                        .eq(param.getSponsorApplyId().length() > 0, MerchantSponsorApplies::getSponsorApplyId, param.getSponsorApplyId())
                        .eq(param.getApplyStatus() >= 0, MerchantSponsorApplies::getApplyStatus, param.getApplyStatus())
                        .select(
                                MerchantSponsorApplies::getSponsorApplyId, MerchantSponsorApplies::getApplyStatus, MerchantSponsorApplies::getApplyType, MerchantSponsorApplies::getReject, MerchantSponsorApplies::getUid,
                                MerchantSponsorApplies::getName, MerchantSponsorApplies::getLogo,
                                MerchantSponsorApplies::getCreatedAt
                        )
        ));
    }

    @Log(title = "主办申请管理", businessType = BusinessType.DETAIL)
    @RequiresPermissions("merchant:sponsor:apply:detail")
    @GetMapping(value = "/details/{sponsorApplyId}")
    public String detail(@PathVariable("sponsorApplyId") String sponsorApplyId, ModelMap mmap) {
        String authId = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();
        return prefix + "/details";
    }
}
