package com.liquidnet.client.admin.zhengzai.merchant.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldsAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.merchant.dto.vo.MerchantCompaniesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.entity.MerchantCompanies;
import com.liquidnet.service.merchant.entity.MerchantFieldApplies;
import com.liquidnet.service.merchant.entity.MerchantFields;
import com.liquidnet.service.merchant.mapper.MerchantFieldAppliesMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.IntStream;

@Slf4j
@Service
public class MerchantFieldAppliesAdminServiceImpl extends ServiceImpl<MerchantFieldAppliesMapper, MerchantFieldApplies> implements IMerchantFieldAppliesAdminService {

    @Autowired
    MerchantRedisUtil merchantRedisUtil;

    @Autowired
    IMerchantFieldsAdminService merchantFieldsAdminService;

    @Autowired
    IMerchantCompaniesAdminService merchantCompaniesAdminService;


    @Override
    @Transactional
    public void applyApprove(String uid, String fieldApplyId, String auditUid, String auditName) {
        List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRedisUtil.getFieldAppliesVosByUid(uid);
        if (CollectionUtils.isEmpty(fieldAppliesVos)) {
            // todo error
        }
        int idx = IntStream.range(0, fieldAppliesVos.size())
                .filter(i -> fieldAppliesVos.get(i).getFieldApplyId().equals(fieldApplyId))
                .findFirst()
                .orElse(-1);
        if (idx < 0) {
            // todo error
        }
        MerchantFieldAppliesVo fieldAppliesVo = fieldAppliesVos.get(idx);

        LocalDateTime now = LocalDateTime.now();

        if (fieldAppliesVo.getApplyType().equals("claim")) {
            // 认领逻辑
            MerchantFieldsVo fieldsVo = merchantRedisUtil.getFieldsVoByFieldId(fieldAppliesVo.getFieldId());
            if (2 != fieldsVo.getClaimStatus() || !fieldsVo.getUid().equals(uid)) {
                // todo error
            }

            // 场地认领 vo
            fieldAppliesVo.setApplyStatus(1);
            fieldAppliesVo.setReject("");
            fieldAppliesVo.setAuditUid(auditUid);
            fieldAppliesVo.setAuditName(auditName);
            fieldAppliesVo.setAuditedAt(now);

            // 公司 entity
            MerchantCompanies companies = new MerchantCompanies();
            companies.setCompanyId(IDGenerator.nextSnowId());
            companies.setName(fieldAppliesVo.getCompanyName());
            companies.setLicenseCode(fieldAppliesVo.getLicenseCode());
            companies.setLicenseImg(fieldAppliesVo.getLicenseImg());
            companies.setLegalName(fieldAppliesVo.getLegalName());
            companies.setLegalIdentity(fieldAppliesVo.getLegalIdentity());
            companies.setLegalIdentityObverse(fieldAppliesVo.getLegalIdentityObverse());
            companies.setLegalIdentityReverse(fieldAppliesVo.getLegalIdentityReverse());
            companies.setCreatedAt(now);
            boolean success = merchantCompaniesAdminService.save(companies);
            if (!success) {
                throw new LiquidnetServiceException();
            }

            // 场地 entity
//            MerchantFields fields = merchantFieldsAdminService.query()


            // 公司 vo
            MerchantCompaniesVo companiesVo = MerchantCompaniesVo.getNew();
            companiesVo.copy(companies);



            // 场地 vo
            fieldsVo.setIsOnline(1);
            fieldsVo.setClaimStatus(1);
            fieldsVo.setUid(uid);
            fieldsVo.setName(fieldAppliesVo.getName());
            fieldsVo.setLogo(fieldAppliesVo.getLogo());
            fieldsVo.setBackground(fieldAppliesVo.getBackground());
            fieldsVo.setDescription(fieldAppliesVo.getDescription());
            fieldsVo.setBuiltDate(fieldAppliesVo.getBuiltDate());
            fieldsVo.setProvinceId(fieldAppliesVo.getProvinceId());
            fieldsVo.setProvinceName(fieldAppliesVo.getProvinceName());
            fieldsVo.setCityId(fieldAppliesVo.getCityId());
            fieldsVo.setCityName(fieldAppliesVo.getCityName());
            fieldsVo.setDistrictId(fieldAppliesVo.getDistrictId());
            fieldsVo.setDistrictName(fieldAppliesVo.getDistrictName());
            fieldsVo.setAddress(fieldAppliesVo.getAddress());
            fieldsVo.setLongitude(fieldAppliesVo.getLongitude());
            fieldsVo.setLatitude(fieldAppliesVo.getLatitude());
            fieldsVo.setContactName(fieldAppliesVo.getContactName());
            fieldsVo.setContactEmail(fieldAppliesVo.getContactEmail());
            fieldsVo.setCompanyId(companiesVo.getCompanyId());
            fieldsVo.setCompaniesVo(companiesVo);
            fieldsVo.setUpdatedAt(now);

            // 场地 mysql
            LambdaUpdateWrapper<MerchantFields> fieldsLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFields.class);
            fieldsLambdaUpdateWrapper.eq(MerchantFields::getFieldId, fieldAppliesVo.getFieldId());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getClaimStatus, fieldsVo.getClaimStatus());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getUid, fieldsVo.getUid());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getName, fieldsVo.getName());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getLogo, fieldsVo.getLogo());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getBackground, fieldsVo.getBackground());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getDescription, fieldsVo.getDescription());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getBuiltDate, fieldsVo.getBuiltDate());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getProvinceId, fieldsVo.getProvinceId());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getProvinceName, fieldsVo.getProvinceName());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getCityId, fieldsVo.getCityId());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getCityName, fieldsVo.getCityName());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getDistrictId, fieldsVo.getDistrictId());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getDistrictName, fieldsVo.getDistrictName());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getAddress, fieldsVo.getAddress());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getLongitude, fieldsVo.getLongitude());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getLatitude, fieldsVo.getLatitude());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getContactName, fieldsVo.getContactName());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getContactEmail, fieldsVo.getContactEmail());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getCompanyId, fieldsVo.getCompanyId());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getUpdatedAt, fieldsVo.getUpdatedAt());
            success = merchantFieldsAdminService.update(fieldsLambdaUpdateWrapper);
            if (!success) {
                throw new LiquidnetServiceException();
            }

            // 场地 sync redis

            // 场地 sync mongo

            // 场地申请 mysql

            // 场地申请 redis

        } else {
            // 创建逻辑

        }
    }

    @Override
    public void applyReject(String uid, String fieldApplyId, String auditUid, String auditName, String reject) {

    }


}
