package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.sweet.task.FeignSweetTaskActivityClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * sweet
 */
@Component
public class SweetCityVoteTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(SweetCityVoteTaskHandler.class);

    @Autowired
    private FeignSweetTaskActivityClient feignSweetTaskActivityClient;

    @XxlJob(value = "sev-sweet:cityVoteStat")
    public ReturnT<String> cityVoteStatHandler() {
        try {
            String jobParam = XxlJobHelper.getJobParam();//执行参数
            log.info("jobParam = " + jobParam);
            String[] paramArray = jobParam.split(",");

            ReturnT<String> success = new ReturnT<>();
            success.setCode(ReturnT.SUCCESS_CODE);

            for (String type : paramArray) {
                log.info("type = " + type);
                Boolean data = feignSweetTaskActivityClient.setStatList(Integer.parseInt(type)).getData();
                log.info("cityVoteStatHandler：结果：{}", data);
                success.setMsg(String.valueOf(data));
            }

            return success;
        } catch (Exception e) {
            log.error("exception of handler:{}", e.getMessage(), e);
            return new ReturnT<>(ReturnT.FAIL_CODE, e.getLocalizedMessage());
        }
    }

}
