package com.liquidnet.service.adam.controller.admin;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.adam.dto.AdamMemberPriceParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.service.admin.IAdamMemberPriceAdminService;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

@ApiSupport(order = 90061)
@Api(tags = "后台管理:会员价格")
@Slf4j
@Validated
@RestController
@RequestMapping("admin/member/price")
public class AdamMemberPriceAdminController extends AdamBaseController {
    @Autowired
    IAdamMemberPriceAdminService adamMemberPriceService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "会员价格列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "memberId", value = "会员卡ID[64]"),
    })
    @GetMapping("list")
    public ResponseDto<List<AdamMemberPriceVo>> list(@NotBlank @RequestParam String memberId) {
        List<AdamMemberPrice> list = adamMemberPriceService.list(
                Wrappers.lambdaQuery(AdamMemberPrice.class).eq(AdamMemberPrice::getMemberId, memberId)
        );
        List<AdamMemberPriceVo> vos = new ArrayList<>();
        list.forEach(r -> {
            vos.add(AdamMemberPriceVo.getNew().copy(r));
        });
        return ResponseDto.success(vos);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "会员价格详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "memberId", value = "会员卡ID[64]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "memberPriceId", value = "会员卡价格ID[64]"),
    })
    @GetMapping("info")
    public ResponseDto<AdamMemberPriceVo> query(@NotBlank @RequestParam String memberId, @NotBlank @RequestParam String memberPriceId) {
        AdamMemberPrice one = adamMemberPriceService.getOne(
                Wrappers.lambdaQuery(AdamMemberPrice.class)
                        .eq(AdamMemberPrice::getMemberPriceId, memberPriceId)
                        .eq(AdamMemberPrice::getMemberId, memberId)
        );
        return ResponseDto.success(AdamMemberPriceVo.getNew().copy(one));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "添加会员价格")
    @PostMapping("add")
    public ResponseDto<AdamMemberPriceVo> add(@Valid @RequestBody AdamMemberPriceParam param) {
        AdamMemberPrice entity = new AdamMemberPrice();
        BeanUtils.copyProperties(param, entity);
        return ResponseDto.success(adamMemberPriceService.add(entity));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "编辑会员价格")
    @PostMapping("edit")
    public ResponseDto<AdamMemberPriceVo> edit(@Valid @RequestBody AdamMemberPriceParam param) {
        return adamMemberPriceService.edit(param) ? ResponseDto.success() : ResponseDto.failure("无效编辑");
    }
}
