package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@ApiModel
@Data
public class GoblinStoreBackOrderListVo implements Cloneable {
    @ApiModelProperty(value = "退款订单id")
    private String backOrderId;
    @ApiModelProperty(value = "退款订单号")
    private String backCode;
    @ApiModelProperty(value = "订单号")
    private String orderCode;
    @ApiModelProperty(value = "类型[1-退款|2-退货]")
    private Integer type;
    @ApiModelProperty(value = "退款／退货状态[0-商铺发起退款|1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)")
    private Integer status;
    @ApiModelProperty(value = " 退款金额")
    private BigDecimal realBackPrice;
    @ApiModelProperty(value = " 创建时间")
    private String createdAt;
    @ApiModelProperty(value = "退款sku")
    private List<GoblinBackOrderSkuVo> backOrderSkuVos;



    private static final GoblinStoreBackOrderListVo obj = new GoblinStoreBackOrderListVo();

    public static GoblinStoreBackOrderListVo getNew() {
        try {
            return (GoblinStoreBackOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreBackOrderListVo();
        }
    }
}
