/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel.netty;

import com.taobao.api.internal.toplink.Logger;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.X509AlwaysTrustManager;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;

public abstract class NettyClient {
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509AlwaysTrustManager()};
    private static NioClientSocketChannelFactory nioClientSocketChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());

    public static InetSocketAddress parse(URI uri) {
        return new InetSocketAddress(uri.getHost(), uri.getPort() > 0 ? uri.getPort() : 80);
    }

    protected static Channel prepareAndConnect(Logger logger, URI uri, ChannelPipeline pipeline, ChannelHandler handler, boolean ssl, int connectTimeoutMillis) throws ChannelException {
        SslHandler sslHandler = ssl ? NettyClient.createSslHandler(uri) : null;
        ClientBootstrap bootstrap = NettyClient.prepareBootstrap(logger, pipeline, handler, sslHandler, connectTimeoutMillis);
        return NettyClient.doConnect(uri, bootstrap, sslHandler);
    }

    private static Channel doConnect(URI uri, ClientBootstrap bootstrap, SslHandler sslHandler) throws ChannelException {
        try {
            Channel channel = bootstrap.connect((SocketAddress)NettyClient.parse(uri)).syncUninterruptibly().getChannel();
            if (sslHandler != null) {
                sslHandler.handshake().syncUninterruptibly();
            }
            return channel;
        }
        catch (Exception e) {
            throw new ChannelException(Text.CONNECT_ERROR, e);
        }
    }

    private static ClientBootstrap prepareBootstrap(Logger logger, final ChannelPipeline pipeline, ChannelHandler handler, SslHandler sslHandler, int connectTimeoutMillis) {
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)nioClientSocketChannelFactory);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("connectTimeoutMillis", (Object)connectTimeoutMillis);
        bootstrap.setOption("writeBufferHighWaterMark", (Object)0xA00000);
        if (sslHandler != null) {
            pipeline.addFirst("ssl", (ChannelHandler)sslHandler);
        }
        if (handler != null) {
            pipeline.addLast("handler", handler);
        }
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return pipeline;
            }
        });
        return bootstrap;
    }

    private static SslHandler createSslHandler(URI uri) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, null);
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            return new SslHandler(sslEngine);
        }
        catch (Exception e) {
            return null;
        }
    }
}

