package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.param.GoblinMixDetailsParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode
public class GoblinMixDetailsVo implements Serializable, Cloneable {
    @ApiModelProperty(position = 0, value = "活动id")
    private String mixId;
    @ApiModelProperty(position = 0, value = "用户id")
    private String userId;
    @ApiModelProperty(position = 1, value = "活动名称")
    private String name;
    @ApiModelProperty(position = 2, value = "开始时间")
    private String timeStart;
    @ApiModelProperty(position = 3, value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(position = 4, value = "展示位置[1-商城|2-数字藏品]")
    private Integer showPosition;
    @ApiModelProperty(position = 5, value = "组合名称")
    private String sellName;
    @ApiModelProperty(position = 6, value = "快递价格")
    private BigDecimal expressPrice;
    @ApiModelProperty(position = 9, value = "商品简介/购买须知")
    private String intro;
    @ApiModelProperty(position = 10, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 11, value = "展示类型为1[详情图片地址]展示类型为2[商品视频地址/数字藏品视频地址]")
    private String video;
    @ApiModelProperty(position = 12, value = "商品详情/藏品详情")
    private String details;
    @ApiModelProperty(position = 13, value = "展示文件类型[1-图片|2-视频]")
    private Integer watchType;
    @ApiModelProperty(position = 14, value = "详情图片地址")
    private String detailUrl;
    @ApiModelProperty(position = 14, value = "设置库存")
    private Integer stock;
    @ApiModelProperty(position = 15, value = "锁定库存")
    private Integer stockLock;
    @ApiModelProperty(position = 16, value = "是否锁定[0-否|1-是]")
    private Integer isLock;
    @ApiModelProperty(position = 17, value = "限购数量[0-无限]")
    private Integer limit;
    @ApiModelProperty(position = 18, value = "白名单类型[0-会员|1-指定用户|2-全部用户]")
    private Integer whiteType;
    @ApiModelProperty(position = 19, value = "白名单xls地址")
    private String whiteUrl;
    @ApiModelProperty(position = 20, value = "配置详情")
    private List<GoblinMixDetailsItemVo> item;
    @ApiModelProperty(position = 21, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 22, value = "状态[6-活动中|7-停用|9-等待开始|10-活动结束]")
    private Integer status;
    @ApiModelProperty(position = 23, value = "销售价格")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 23, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(position = 24, value = "IOS支付方式[0-第三方支付|1-苹果支付]")
    private Integer payType;
    @ApiModelProperty(position = 25, value = "xls名称")
    private String xlsName;
    @ApiModelProperty(position = 26, value = "店铺id")
    private String storeId;

    private static final GoblinMixDetailsVo obj = new GoblinMixDetailsVo();

    public static GoblinMixDetailsVo getNew() {
        try {
            return (GoblinMixDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixDetailsVo();
        }
    }

    public GoblinMixDetailsVo copyByInsert(String mixId, GoblinMixDetailsParam source, List<GoblinMixDetailsItemVo> itemList, String uid, BigDecimal sellPrice, BigDecimal price) {
        if (null == source) return this;
        this.setMixId(mixId);
        this.setUserId(uid);
        this.setName(source.getName());
        this.setTimeStart(source.getTimeStart());
        this.setTimeEnd(source.getTimeEnd());
        this.setShowPosition(source.getShowPosition());
        this.setSellName(source.getSellName());
        this.setExpressPrice(BigDecimal.ZERO);//TODO 0.5需求
        this.setIntro(source.getIntro());
        this.setCoverPic(source.getCoverPic());
        this.setVideo(source.getVideo());
        this.setDetails(source.getDetails());
        this.setWatchType(source.getWatchType());
        this.setDetailUrl(source.getDetailUrl());
        this.setStock(source.getStock());
        this.setStockLock(source.getStockLock());
        this.setIsLock(1);
        this.setLimit(source.getLimit());
        this.setWhiteType(source.getWhiteType());
        this.setWhiteUrl(source.getWhiteUrl());
        this.setItem(itemList);
        this.setCreatedAt(DateUtil.getNowTime());
        this.setStatus(6);
        this.setSellPrice(sellPrice);
        this.setPrice(price);
        this.setPayType(source.getPayType());
        this.setXlsName(source.getXlsName());
        this.setStoreId(source.getStoreId());
        return this;
    }
}
