package com.liquidnet.service.goblin.param;

import com.liquidnet.service.goblin.dto.vo.GoblinMixDetailsItemVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode
public class GoblinMixDetailsParam implements Serializable, Cloneable {
    @ApiModelProperty(position = 1, value = "活动名称")
    private String name;
    @ApiModelProperty(position = 2, value = "开始时间")
    private String timeStart;
    @ApiModelProperty(position = 3, value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(position = 4, value = "展示位置[1-商城|2-数字藏品]")
    private Integer showPosition;
    @ApiModelProperty(position = 5, value = "组合名称")
    private String sellName;
    @ApiModelProperty(position = 9, value = "商品简介/购买须知")
    private String intro;
    @ApiModelProperty(position = 10, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 11, value = "展示类型为1[详情图片地址]展示类型为2[商品视频地址/数字藏品视频地址]")
    private String video;
    @ApiModelProperty(position = 12, value = "商品详情/藏品详情")
    private String details;
    @ApiModelProperty(position = 13, value = "展示文件类型[1-图片|2-视频]")
    private Integer watchType;
    @ApiModelProperty(position = 14, value = "详情图片地址")
    private String detailUrl;
    @ApiModelProperty(position = 14, value = "设置库存")
    private Integer stock;
    @ApiModelProperty(position = 15, value = "锁定库存")
    private Integer stockLock;
    @ApiModelProperty(position = 16, value = "是否锁定[0-否|1-是]")
    private String isLock;
    @ApiModelProperty(position = 17, value = "限购数量[0-无限]")
    private Integer limit;
    @ApiModelProperty(position = 18, value = "白名单类型[0-会员|1-指定用户|2-全部用户]")
    private Integer whiteType;
    @ApiModelProperty(position = 19, value = "白名单xls地址")
    private String whiteUrl;
    @ApiModelProperty(position = 20, value = "配置详情")
    private List<GoblinMixDetailsItemParam> item;
    @ApiModelProperty(position = 19, value = "IOS支付方式[0-第三方支付|1-苹果支付]")
    private Integer payType;
    @ApiModelProperty(position = 20, value = "xls名称")
    private String xlsName;
    @ApiModelProperty(position = 21, value = "店铺id")
    private String storeId;


    private static final GoblinMixDetailsParam obj = new GoblinMixDetailsParam();

    public static GoblinMixDetailsParam getNew() {
        try {
            return (GoblinMixDetailsParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixDetailsParam();
        }
    }
}
