package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.entity.SweetCollectionReservation;
import com.liquidnet.service.sweet.mapper.SweetCollectionReservationMapper;
import com.liquidnet.service.sweet.service.ISweetCollectionReservationService;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisActivityUtils;
import com.liquidnet.service.sweet.vo.SweetCollectionReservationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;

/**
 * <p>
 * 数字藏品预约活动表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-18
 */
@Service
public class SweetCollectionReservationServiceImpl extends ServiceImpl<SweetCollectionReservationMapper, SweetCollectionReservation> implements ISweetCollectionReservationService {

    @Autowired
    private RedisActivityUtils activityUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<SweetCollectionReservationVo> info(String unionId) {
        SweetCollectionReservationVo reserved = activityUtils.getSweetCollectionReserved(unionId);
        LocalDateTime endTime = activityUtils.getEndTime("reservation");
        LocalDateTime nowTime = LocalDateTime.now();
        if (null == reserved) {
            reserved = SweetCollectionReservationVo.getNew();
        }
        if (null == endTime || nowTime.isAfter(endTime)) {
            reserved.setStatus(2);
        } else {
            reserved.setStatus(1);
        }
        return ResponseDto.success(reserved);
    }

    @Override
    public ResponseDto<Boolean> time(String endTime) {
        activityUtils.setEndTime("reservation", endTime);
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> create(String unionId, String nickname, String mobile, String mailbox, String enterpriseName, String title) {
        SweetCollectionReservation reservation = SweetCollectionReservation.getNew();
        String id = IDGenerator.nextSnowId();
        LocalDateTime nowTime = LocalDateTime.now();
        reservation.setReservationId(id);
        reservation.setUnionId(unionId);
        reservation.setNickname(nickname);
        reservation.setMobile(mobile);
        reservation.setMailbox(mailbox);
        reservation.setEnterpriseName(enterpriseName);
        reservation.setTitle(title);
        reservation.setCreatedAt(nowTime);
        reservation.setUpdatedAt(nowTime);


        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_collection_reservation.insert"));
        sqlsDataA.add(new Object[]{
                id, unionId, nickname, mobile, mailbox, enterpriseName, title, nowTime, nowTime
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_ANSWER_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        SweetCollectionReservationVo reservationVo = SweetCollectionReservationVo.getNew().copy(reservation);
        activityUtils.setSweetCollectionReserved(reservationVo);

        return ResponseDto.success();
    }
}
