package com.liquidnet.service.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.vo.SweetCollectionReservationVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Component
@Slf4j
public class RedisActivityUtils {

    @Autowired
    private RedisUtil redisUtil;

    public void setSweetCollectionReserved(SweetCollectionReservationVo reservationVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_COLLECTION_RESERVATION_USER.concat(reservationVo.getUnionId());
        redisUtil.set(redisKey, reservationVo);
    }

    public SweetCollectionReservationVo getSweetCollectionReserved(String unionId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_COLLECTION_RESERVATION_USER.concat(unionId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (SweetCollectionReservationVo) obj;
        }
    }

    public void setEndTime(String type, String endTime) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ACTIVITY_END_TIME.concat(type);
        redisUtil.set(redisKey, endTime);
    }
    public LocalDateTime getEndTime(String type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ACTIVITY_END_TIME.concat(type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            String time = (String) obj;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return LocalDateTime.parse(time, formatter);
        }
    }

}
