package com.liquidnet.client.admin.web.controller.zhengzai.stone;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExportVo;
import com.liquidnet.client.admin.zhengzai.stone.service.IItemService;
import com.liquidnet.client.admin.zhengzai.stone.service.IScoreService;
import com.liquidnet.client.admin.zhengzai.stone.service.dto.StoneScoreListExportDto;
import com.liquidnet.client.admin.zhengzai.stone.service.vo.StoneUserScoreDetailVo;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.param.StoneItemBuildParam;
import com.liquidnet.service.stone.param.StoneListParam;
import com.liquidnet.service.stone.param.StoneScoreListParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Api(tags = "积分明细")
@Controller
@RequestMapping("stone/logs")
public class StoneLogsController extends BaseController {
    private String prefix = "zhengzai/stone";

    @Autowired
    private IScoreService iScoreService;

    @GetMapping("integralStore")
    @ApiOperation(value = "积分明细:列表View", position = 0)
    public String integralStore(ModelMap mmap) {
        return prefix + "/integralList";
    }

    @GetMapping("integralStoreEdit")
    @ApiOperation(value = "积分明细:详情View", position = 1)
    public String integralStoreEdit(ModelMap mmap) {
        return prefix + "/integralDetail";
    }

    @Log(title = "积分明细:列表")
    @ApiOperation(value = "积分明细:列表", position = 2)
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(StoneScoreListParam listParam) {
//        startPage();
        List<StoneScoreListDto> result = iScoreService.list(listParam);
        return this.getDataTable(result);
    }

    @Log(title = "积分明细:修改状态")
    @PutMapping("change/status")
    @ApiOperation(value = "积分明细:修改状态", position = 3)
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "状态[1-正常|2-冻结]"),
    })
    public AjaxResult status(@RequestParam("uid") String uid, @RequestParam("status") Integer status) {
        String result = iScoreService.changeStatus(uid, status);
        return AjaxResult.success(result);
    }

    @Log(title = "积分明细:详情")
    @GetMapping("details")
    @ApiOperation(value = "积分明细:详情", position = 4)
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "用户id"),
    })
    public AjaxResult details(@RequestParam("uid") String uid) {
        StoneUserScoreDetailVo result = iScoreService.userScoreDetail(uid);
        return AjaxResult.success(result);
    }

    @Log(title = "积分明细:导出列表[根据uid]")
    @PostMapping("list/export")
    @ResponseBody
    public AjaxResult export(String uidString) {
        List<StoneScoreListExportDto> list = iScoreService.listExport(uidString.split(","));
        ExcelUtil<StoneScoreListExportDto> util = new ExcelUtil(StoneScoreListExportDto.class);
        return util.exportExcel(list, "积分导出");
    }
}
