package com.liquidnet.service.dragon.channel.douyinpay.strategy;

import com.liquidnet.service.dragon.channel.douyinpay.strategy.annotation.StrategyDouYinPayHandler;
import com.liquidnet.service.dragon.channel.wepay.strategy.IWepayStrategy;
import com.liquidnet.service.dragon.channel.wepay.strategy.WepayStrategyContext;
import com.liquidnet.service.dragon.channel.wepay.strategy.annotation.StrategyWepayHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;


/**
 * @author zhangfuxin
 * @Description:
 * @date 2021/11/9 下午4:12
 */
@Component
public class DouYinpayStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyDouYinPayHandler.class);
        DouYinayStrategyContext strategyContext = event.getApplicationContext().getBean(DouYinayStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyDouYinPayHandler typeHandler = bean.getClass().getAnnotation(StrategyDouYinPayHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IDouYinpayStrategy) bean);
        });
    }
}