package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "AdamMemberOrderSimpleVo", description = "会员订单列表信息")
@Data
public class AdamMemberOrderSimpleVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3978877550469933116L;
    @ApiModelProperty(position = 10, value = "订单号")
    private String orderNo;
    @ApiModelProperty(position = 11, value = "订单状态:0-未支付,1-已支付,2-已关闭,3-超时付,4-退款中,5-已退款")
    private Integer state;
    @ApiModelProperty(position = 12, value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @ApiModelProperty(position = 13, value = "会员类型名称")
    private String memberName;
    @ApiModelProperty(position = 14, value = "购买方式:0-购买会员,1-购买会员码,2-会员码兑换,3-礼包码兑换")
    private Integer mode;
    @ApiModelProperty(position = 16, value = "价格")
    private BigDecimal price;
    @ApiModelProperty(position = 17, value = "实付价格")
    private BigDecimal pricePaid;

    private static final AdamMemberOrderSimpleVo obj = new AdamMemberOrderSimpleVo();

    public static AdamMemberOrderSimpleVo getNew() {
        try {
            return (AdamMemberOrderSimpleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderSimpleVo();
        }
    }

    public AdamMemberOrderSimpleVo copy(AdamMemberOrderVo source) {
        if (null == source) return this;
        this.setOrderNo(source.getOrderNo());
        this.setState(source.getState());
        this.setCreatedAt(source.getCreatedAt());
        this.setMemberName(source.getMemberName());
        this.setMode(source.getMode());
        this.setPrice(source.getPrice());
        this.setPricePaid(source.getPricePaid());
        return this;
    }
}
