package com.liquidnet.service.consumer.adam.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.consumer.adam.receiver.ConsumerAdamSqlUCenterRdsReceiver;
import com.liquidnet.service.consumer.adam.receiver.ConsumerAdamSqlUMemberRdsReceiver;
import com.liquidnet.service.consumer.adam.receiver.ConsumerAdamSqlURegisterRdsReceiver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.*;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.AdamQueue;

@Slf4j
@Configuration
public class ConsumerAdamSqlUcenterRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ConsumerAdamSqlURegisterRdsReceiver consumerAdamURegisterRdsReceiver;
    @Autowired
    ConsumerAdamSqlUCenterRdsReceiver consumerAdamUCenterRdsReceiver;
    @Autowired
    ConsumerAdamSqlUMemberRdsReceiver consumerAdamUMemberRdsReceiver;

    private void initStream(String key, String group) {
        try {
            if (!stringRedisTemplate.hasKey(key)) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", " ");
                StreamOperations<String, Object, Object> stringObjectObjectStreamOperations = stringRedisTemplate.opsForStream();
                RecordId recordId = stringObjectObjectStreamOperations.add(StreamRecords.mapBacked(map).withStreamKey(key));
                stringObjectObjectStreamOperations.createGroup(key, group);
                stringObjectObjectStreamOperations.delete(key, recordId.getValue());
            } else {
                log.info("redis stream exist [{},{}]", key, group);
            }
        } catch (Exception e) {
            log.error("Ex:redis stream init [{},{}]", key, group, e);
        }
    }

    @Bean// 用户注册
    public List<Subscription> subscriptionSqlURegister(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        AdamQueue stream = AdamQueue.SQL_UREGISTER;
        this.initStream(stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerAdamURegisterRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean// 用户中心
    public List<Subscription> subscriptionSqlUCenter(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        AdamQueue stream = AdamQueue.SQL_UCENTER;
        this.initStream(stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerAdamUCenterRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean// 购买会员
    public List<Subscription> subscriptionSqlUMember(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        AdamQueue stream = AdamQueue.SQL_UMEMBER;
        this.initStream(stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerAdamUMemberRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
}
