package com.liquidnet.service.sweet.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "SweetYbEnrollParam", description = "YB报名表入参")
@Data
public class SweetYbEnrollParam implements Serializable {

    private static final long serialVersionUID = 487812347569053758L;

    @ApiModelProperty(position = 11, required = false, value = "联系电话", example = "15888888888")
    private String contactTell;

    @ApiModelProperty(position = 12, required = false, value = "联系微信", example = "jiangxiulong")
    private String contactWechat;

    @ApiModelProperty(position = 13, required = true, value = "乐队名称", example = "新裤子")
    @NotBlank(message = "请填写乐队名称")
    private String nickname;

    @ApiModelProperty(position = 14, required = true, value = "风格", example = "摇滚，世界音乐，国风，民谣，电子，其他")
    @NotBlank(message = "请选择风格")
    private String style;

    @ApiModelProperty(position = 15, required = true, value = "乐队照片", example = "img.zhengzai.tv/img.png")
    @NotBlank(message = "请上传乐队照片")
    private String imgUrl;

    @ApiModelProperty(position = 16, required = true, value = "音频文件", example = "img.zhengzai.tv/audio.mp3")
    @NotBlank(message = "请上传音频文件")
    private String audioUrl;

    @ApiModelProperty(position = 17, required = false, value = "院校", example = " 川音，现音，其他")
    @NotBlank(message = "keyword1不能为空")
    private String universities;

}
