package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinZhengzaiMarketService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinInsertZhengzaiParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreZhengzaiParam;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketSpuListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfZhengzaiSkuVo;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiStoreListVo;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 商铺活动管理
 */
@Slf4j
@RestController
@Api(tags = "活动-正在下单")
@RequestMapping("goblin/marketing")
public class GoblinSelfZhengzaiController extends BaseController {

    @Autowired
    IGoblinZhengzaiMarketService goblinZhengzaiMarketService;

    @PostMapping("zhengzai/list")
    @ApiOperation("活动详情-正在下单列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageNum", value = "页数", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "purchaseName", value = "活动名称", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "startTime", value = "活动开始时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "endTime", value = "活动结束时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "createdAt", value = "活动创建时间", example = ""),
    })
    public TableDataInfo purchasingList(@RequestParam(value = "pageNum", required = false) @Valid Integer page,
                                        @RequestParam(value = "purchaseName", required = false) String purchaseName,
                                        @RequestParam(value = "status", required = false) Integer status,
                                        @RequestParam(value = "startTime", required = false) String st,
                                        @RequestParam(value = "endTime", required = false) String et,
                                        @RequestParam(value = "createdAt", required = false) String ct) {
        LocalDateTime now = LocalDateTime.now();
        List<GoblinSelfMarketing> list = goblinZhengzaiMarketService.zhengzaiList(page, purchaseName, status, st, et, ct).getData();
        startPage();
        for (GoblinSelfMarketing item : list) {
            if (item.getStatus() != 7) {
                if (now.isBefore(item.getStartTime())) {
                    item.setStatus(0);
                } else if (now.isAfter(item.getEndTime())) {
                    item.setStatus(2);
                } else {
                    item.setStatus(1);
                }
            }
        }
        return getDataTable(list);
    }

    @PostMapping("zhengzai/status")
    @ApiOperation("活动操作-正在下单-修改状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "活动状态[0-等待开始|7-停用|-1-删除]", example = "0"),
    })
    public ResponseDto<Boolean> purchasingStatus(@RequestParam(value = "marketId") @Valid String marketId,
                                                 @RequestParam(value = "status") @Valid Integer status) {
        return goblinZhengzaiMarketService.zhengzaiStatus(marketId, status);
    }

    @PostMapping("zhengzai")
    @ApiOperation("创建活动-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<String> purchasingInsert(GoblinStoreZhengzaiParam goblinStoreZhengzaiParam) {
        return goblinZhengzaiMarketService.zhengzaiInsert(goblinStoreZhengzaiParam.getName(), goblinStoreZhengzaiParam.getPerformanceId(), goblinStoreZhengzaiParam.getStartTime(), goblinStoreZhengzaiParam.getEndTime());
    }

    @PostMapping("zhengzai/change")
    @ApiOperation("修改活动-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<String> purchasingUpdate(GoblinStoreZhengzaiParam goblinStoreZhengzaiParam) {
        goblinZhengzaiMarketService.zhengzaiUpdate(goblinStoreZhengzaiParam.getMarketId(), goblinStoreZhengzaiParam.getName(), goblinStoreZhengzaiParam.getStartTime(), goblinStoreZhengzaiParam.getEndTime());
        return ResponseDto.success();
    }

    @PostMapping("zhengzai/details")
    @ApiOperation("活动详情-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<GoblinSelfMarketingVo> purchasingDetails(@RequestParam("marketId") @Valid String marketId) {
        return goblinZhengzaiMarketService.zhengzaiDetails(marketId);
    }


    @PostMapping("zhengzai/store")
    @ApiOperation("活动详情-正在下单-新增店铺")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> purchasingStore(@RequestBody List<GoblinInsertZhengzaiParam> params) {
        return goblinZhengzaiMarketService.zhengzaiStore(params);
    }

//    @PostMapping("zhengzai/store/update")
//    @ApiOperation("活动详情-正在下单-修改店铺")
//    @ApiResponse(code = 200, message = "接口返回对象参数")
//    public ResponseDto<Boolean> purchasingStoreUpdate(@RequestBody List<GoblinInsertZhengzaiParam> params) {
//        return goblinZhengzaiMarketService.zhengzaiStore(params);
//    }


    @PostMapping("zhengzai/store/list")
    @ApiOperation("活动详情-正在下单-参加活动店铺列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiStoreListVo>> purchasingSkuDel(@RequestParam("marketId") @Valid String marketId) {
        return goblinZhengzaiMarketService.zhengzaiStoreList(marketId);
    }

    @PostMapping("zhengzai/spu")
    @ApiOperation("活动详情-正在下单-店铺spu列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "pageNum", value = "页数", example = "1"),
    })
    public ResponseDto<List<GoblinMarketSpuListVo>> purchasingSpuList(@RequestParam("marketId") @Valid String marketId,
                                                                      @RequestParam("storeId") @Valid String storeId,
                                                                      @RequestParam("pageNum") @Valid int page) {
        return goblinZhengzaiMarketService.zhengzaiSpuList(marketId, storeId, page);
    }

    @GetMapping("zhengzai/sku")
    @ApiOperation("活动详情-正在下单-店铺sku列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId", example = "1"),
    })
    public ResponseDto<List<GoblinSelfZhengzaiSkuVo>> purchasingSkuList(@RequestParam("marketId") @Valid String marketId,
                                                                        @RequestParam("storeId") @Valid String storeId,
                                                                        @RequestParam("spuId") @Valid String spuId) {
        return goblinZhengzaiMarketService.zhengzaiSkuList(marketId, storeId, spuId);
    }

    @PostMapping("zhengzai/sku/del")
    @ApiOperation("活动详情-正在下单-店铺sku删除")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "storeId", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "skuId", value = "skuId", example = "1"),
    })
    public ResponseDto<Boolean> purchasingSkuDel(@RequestParam("marketId") @Valid String marketId,
                                                 @RequestParam("storeId") @Valid String storeId,
                                                 @RequestParam("skuId") @Valid String skuId) {
        return goblinZhengzaiMarketService.zhengzaiSkuDel(marketId, storeId, skuId);
    }

}
