/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.api;

import com.taobao.api.internal.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliyunSignature {
    private static final String ENCODING = "UTF-8";
    private static String httpMethod = "POST";

    public static String computeSignature(Map<String, String> parameters, String accessKeySecret) throws Exception {
        Object[] sortedKeys = parameters.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        String SEPARATOR = "&";
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Object key : sortedKeys) {
            canonicalizedQueryString.append("&").append(AliyunSignature.percentEncode((String)key)).append("=").append(AliyunSignature.percentEncode(parameters.get(key)));
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(httpMethod).append("&");
        stringToSign.append(AliyunSignature.percentEncode("/")).append("&");
        stringToSign.append(AliyunSignature.percentEncode(canonicalizedQueryString.toString().substring(1)));
        String signature = AliyunSignature.calculateSignature(accessKeySecret + "&", stringToSign.toString());
        return signature;
    }

    private static String calculateSignature(String key, String stringToSign) throws Exception {
        String ALGORITHM = "HmacSHA1";
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(key.getBytes(ENCODING), "HmacSHA1"));
        byte[] signData = mac.doFinal(stringToSign.getBytes(ENCODING));
        return Base64.encodeToString(signData, false);
    }

    private static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }
}

