package com.liquidnet.service.bank.currencycloud.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class BankCcAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * Legal entity. company
     * individual
     */
    private String legalEntityType;

    /**
     * Account name.
     */
    private String accountName;

    private String brand;

    private String yourReference;

    private String status;

    /**
     * First line of address.
     */
    private String street;

    /**
     * City.
     */
    private String city;

    private String stateOrProvince;

    /**
     * Two-letter country code.
     */
    private String country;

    private String postalCode;

    private String spreadTable;

    private Date createdAt;

    private Date updatedAt;

    /**
     * A legal document that verifies the identity of the account owner.
     */
    private String identificationType;

    /**
     * A unique reference code for the identification document, such as a passport number. Required if "identification_type" is provided.
     */
    private String identificationValue;

    private String shortReference;

    private Boolean apiTrading;

    private Boolean onlineTrading;

    private Boolean phoneTrading;

    private Boolean processThirdPartyFunds;

    private String settlementType;

    /**
     * create time
     */
    private LocalDateTime createTime;

    /**
     * update time
     */
    private LocalDateTime updateTime;

}
