package com.liquidnet.service.reconciliation.strategy.infodata;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 资金数据获取上下文
 * @class: GetFundDataStrategyContext
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:35
 */
@Component
public class GetInfoDataStrategyContext {
    private final Map<String, IGetInfoDataStrategy> handlerMap = new HashMap<>();

    public IGetInfoDataStrategy getStrategy(String code) {
        return handlerMap.get(code);
    }

    public void putStrategy(String code, IGetInfoDataStrategy strategy) {
        handlerMap.put(code, strategy);
    }
}
