package com.liquidnet.service.kylin.timerTask;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.partner.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketTimesPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@Component
public class PerformanceVoTask {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;

    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;

    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;


    /**
     * 根据票状态判断 演出状态 票状态
     *
     * @param performanceSingleId
     */
    public void performanceVoStatus(String performanceSingleId) {

        LocalDateTime timeNow = LocalDateTime.now();
        List<String> performanceIdList = new ArrayList<>();

        if (performanceSingleId.isEmpty()) {
            List<KylinPerformanceVo> kylinPerformanceVoList = mongoTemplate.findAll(KylinPerformanceVo.class);
            for (KylinPerformanceVo kylinPerformanceVoItem : kylinPerformanceVoList) {
                performanceIdList.add(kylinPerformanceVoItem.getPerformancesId());
            }
        } else {
            performanceIdList.add(performanceSingleId);
        }

        for (String performancesId : performanceIdList) {
            //场次
            List<KylinTicketTimesVo> timesData = mongoTemplate.find(
                    Query.query(Criteria.where("performanceId").is(performancesId)),
                    KylinTicketTimesVo.class, KylinTicketTimesVo.class.getSimpleName()
            );

            if(timesData.size()==0){
                continue;
            }

            //总循环次数
            int ticketCount = 0;
            //未开售次数
            int status9Count = 0;
            //售罄次数
            int status8Count = 0;
            //已结束次数
            int status10Count = 0;
            //缺票登记
            int isLackRegister = 0;
            //会员
            int isMember = 0;
            //专属
            int isExclusive = 0;
            //提前
            int isAdvance = 0;
            //优惠
            int isDiscount = 0;
            //价格
            BigDecimal price = new BigDecimal("0.00");
            LocalDateTime stopSellTime = null;
            LocalDateTime sellTime = null;

            //演出数据
            HashMap<String, Object> mapPerformance = new HashMap<>();
            int appStatus = 6;
            for (KylinTicketTimesVo kylinTicketTimesVoItem : timesData) {
                //票
                List<KylinTicketVo> kylinTicketVoList = mongoTemplate.find(
                        Query.query(Criteria.where("timeId").is(kylinTicketTimesVoItem.getTimeId())),
                        KylinTicketVo.class, KylinTicketVo.class.getSimpleName()
                );
                ticketCount += kylinTicketVoList.size();
                for (KylinTicketVo kylinTicketVoItem : kylinTicketVoList) {
                    KylinTickets tickets = ticketsMapper.selectOne(
                            new UpdateWrapper<KylinTickets>().eq("tickets_id", kylinTicketVoItem.getTicketsId()
                            )
                    );
                    //时间判断
                    LocalDateTime timeStart = LocalDateTime.parse(kylinTicketVoItem.getMemberTimeStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    LocalDateTime timeEnd = LocalDateTime.parse(kylinTicketVoItem.getTimeEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    int status = 0;
                    if (timeStart.isAfter(timeNow)) {
                        //未开始
                        status = 9;
                        status9Count += 1;
                    } else if (timeEnd.isBefore(timeNow)) {
                        //结束
                        status = 10;
                        status10Count += 1;
                    } else {
                        //库存判断
                        int surplusGeneral = dataUtils.getSurplusGeneral(kylinTicketVoItem.getTicketsId());

                        if (surplusGeneral > 0) {
                            status = 6;
                        } else {
                            status = 8;
                            status8Count += 1;
                        }
                    }

                    //修改票状态
                    HashMap<String, Object> mapTicket = new HashMap<>();
                    mapTicket.put("status", status);
                    BasicDBObject objectTicket = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapTicket));
                    mongoTemplate.getCollection(KylinTicketVo.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("ticketsId").is(kylinTicketVoItem.getTicketsId())).getQueryObject(),
                            objectTicket
                    );
                    //演出状态
                    if (status == 6) {//单一票 可购买 则为可购买
                        appStatus = 6;
                    } else if (ticketCount == status8Count) {//全票售罄为售罄
                        appStatus = 8;
                    } else if (ticketCount == status9Count) {//全票未开始 为未开始
                        appStatus = 9;
                    } else if (ticketCount == status10Count) {//全票结束 为结束
                        appStatus = 10;
                    }


                    if (kylinTicketVoItem.getIsMember() == 1) {
                        if (kylinTicketVoItem.getMemberPrice().compareTo(kylinTicketVoItem.getPrice()) != 0) {
                            isDiscount = 1;
                        }

                        if (!kylinTicketVoItem.getTimeStart().equalsIgnoreCase(kylinTicketVoItem.getMemberTimeStart())) {
                            isAdvance = 1;
                        }

                        if (kylinTicketVoItem.getIsMember() == 1) {
                            isMember = 1;
                        }

                        if (kylinTicketVoItem.getIsExclusive() == 1) {
                            isExclusive = 1;
                        }
                    }

                    if (kylinTicketVoItem.getIsLackRegister() == 1) {
                        isLackRegister = 1;
                    }

                    if (price.subtract(kylinTicketVoItem.getMemberPrice()).compareTo(new BigDecimal("0.00")) < 0) {
                        price = kylinTicketVoItem.getMemberPrice();
                    }
                    if (stopSellTime == null || stopSellTime.isBefore(tickets.getTimeEnd())) {
                        stopSellTime = tickets.getTimeEnd();
                    }
                    if (sellTime == null || sellTime.isAfter(tickets.getTimeStart().plusMinutes(-tickets.getAdvanceMinuteMember()))) {
                        sellTime = tickets.getTimeStart().plusMinutes(-tickets.getAdvanceMinuteMember());
                    }

                }
            }
            //修改演出状态
            mapPerformance.put("appStatus", appStatus);
            mapPerformance.put("isLackRegister", isLackRegister);
            mapPerformance.put("isExclusive", isExclusive);
            mapPerformance.put("isMember", isMember);
            mapPerformance.put("isAdvance", isAdvance);
            mapPerformance.put("isDiscount", isDiscount);
            mapPerformance.put("sellTime", sellTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            mapPerformance.put("stopSellTime", stopSellTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            mapPerformance.put("price", price+"起");
            BasicDBObject objectPerformance = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapPerformance));
            mongoTemplate.getCollection(KylinPerformanceVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                    objectPerformance
            );
        }
    }


    /**
     * 生成 PerformanceCreatePartnerVo(用于审核第一次提交数据)
     *
     * @param performancesId
     * @return
     */
    public KylinPerformanceMisVo getPerformanceMisVo(String performancesId) {
        PerformancePartnerVo performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
        List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
        List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();

        ArrayList<BigDecimal> floatList = new ArrayList<>();
        ArrayList<String> StringList = new ArrayList<>();

        for (KylinTicketTimesPartnerVo ticketTimes : kylinTicketTimesPartnerVos) {
            TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
            BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
            List<KylinTicketPartnerVo> kylinTicketPartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
            ticketTimesTicketCreatePartnerVo.setTicket(kylinTicketPartnerVos);
            ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
            for (KylinTicketPartnerVo kylinTicketPartnerVoItem : kylinTicketPartnerVos) {
                floatList.add(kylinTicketPartnerVoItem.getPrice());
                StringList.add(kylinTicketPartnerVoItem.getTimeEnd());
            }
        }
        KylinPerformanceMisVo kylinPerformanceMisVo = new KylinPerformanceMisVo();
        BeanUtils.copyProperties(performanceData, kylinPerformanceMisVo);

        floatList.sort(Comparator.reverseOrder());
        StringList.sort(Comparator.naturalOrder());

        kylinPerformanceMisVo.setPrice(floatList.get(0) + "起");
        kylinPerformanceMisVo.setStopSellTime(StringList.get(0));
        kylinPerformanceMisVo.setTicketTimes(ticketTimesTicketCreatePartnerVoList);

//        if (performanceMisVo.getStatus() != 0) {
//            performanceMisVo.setStatus(null);
//            performanceMisVo.setStatusSell(null);
//            performanceMisVo.setRejectTxt("");
//            performanceMisVo.setIsShow(1);
        kylinPerformanceMisVo.setIsDistribution(0);
        kylinPerformanceMisVo.setSyncAgent(0);
        kylinPerformanceMisVo.setAuditStatus(0);
//        }

//        boolean exists = mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceMisVo.class, PerformanceMisVo.class.getSimpleName());
//
//        if (!exists) {
//            PerformanceMisVo data = mongoTemplate.insert(
//                    performanceMisVo, PerformanceMisVo.class.getSimpleName()
//            );
//        }

        return kylinPerformanceMisVo;
    }

    /**
     * 插入数据库
     *
     * @param performancesId
     * @param map
     * @param kylinPerformanceMisVo
     * @param updatedAt
     */
    public void createPerformanceMySql(String performancesId, HashMap<String, Object> map, KylinPerformanceMisVo kylinPerformanceMisVo, LocalDateTime updatedAt) {
        try {
            // 判断演出是否存在 存在删除


            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getTimeEnd())));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
            performanceStatus.setCreatedAt(performances.getCreatedAt());
            performanceStatus.setAuditStatus(0);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceStatus.setLimitCountMember(1);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
            performanceRelations.setCreatedAt(performances.getCreatedAt());
            performanceRelations.setUpdatedAt(updatedAt);

            performancesMapper.delete(new UpdateWrapper<KylinPerformances>().eq("performances_id", performances.getPerformancesId()));
            performancesMapper.insert(performances);
            performanceStatusMapper.delete(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performanceStatus.getPerformanceId()));
            performanceStatusMapper.insert(performanceStatus);
            performanceRelationsMapper.delete(new UpdateWrapper<KylinPerformanceRelations>().eq("performance_id", performanceRelations.getPerformanceId()));
            performanceRelationsMapper.insert(performanceRelations);


            //场次数据
            List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (KylinTicketTimesPartnerVo ticketTimeItem : kylinTicketTimesPartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getCreatedAt())));
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                ticketTimeRelation.setUpdatedAt(updatedAt);

                ticketTimesMapper.delete(new UpdateWrapper<KylinTicketTimes>().eq("ticket_times_id", ticketTimes.getTicketTimesId()));
                ticketTimesMapper.insert(ticketTimes);
                ticketTimeRelationMapper.delete(new UpdateWrapper<KylinTicketTimeRelation>().eq("ticket_time_relation_id", ticketTimeRelation.getTimesId()));
                ticketTimeRelationMapper.insert(ticketTimeRelation);

                //修改票
                for (KylinTicketPartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                    Document docTicket = mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).findOneAndUpdate(
                            Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                            objectTicketVo,
                            new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
                    );
                    KylinTicketPartnerVo kylinTicketPartnerVo = JsonUtils.fromJson(docTicket.toJson(), KylinTicketPartnerVo.class);

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketRelations);

                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    if (ticketItem.getIsExpress() == 1) {
                        tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                    }
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getCreatedAt())));
                    tickets.setUpdatedAt(updatedAt);

                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                    ticketStatus.setTicketId(tickets.getTicketsId());
//                    ticketStatus.setCounts(1);
                    ticketStatus.setIsMember(1);
                    ticketStatus.setIsExclusive(0);
                    ticketStatus.setIsTrueName(performanceStatus.getIsTrueName());
                    ticketStatus.setMemberLimitCount(1);
                    ticketStatus.setStatusExchange(7);
                    if (ticketItem.getIsShowCode() == 1) {
                        ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));
                    }

                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketsMapper.delete(new UpdateWrapper<KylinTickets>().eq("tickets_id", tickets.getTicketsId()));
                    ticketsMapper.insert(tickets);
                    ticketStatusMapper.delete(new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketStatus.getTicketId()));
                    ticketStatusMapper.insert(ticketStatus);
                    ticketRelationsMapper.delete(new UpdateWrapper<KylinTicketRelations>().eq("ticket_id", ticketRelations.getTicketId()));
                    ticketRelationsMapper.insert(ticketRelations);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 修改数据库
     *
     * @param performancesId
     * @param map
     * @param performanceUpdateMisVo
     * @param updatedAt
     */
    public void updatePerformanceMySql(String performancesId, HashMap<String, Object> map, KylinPerformanceMisVo performanceUpdateMisVo, LocalDateTime updatedAt, Integer auditStatus) {
        try {
            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(performanceUpdateMisVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(performanceUpdateMisVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(performanceUpdateMisVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceUpdateMisVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceUpdateMisVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceUpdateMisVo.getTimeEnd())));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
            performanceStatus.setCreatedAt(null);
            performanceStatus.setStatus(null);
            performanceStatus.setStatusSell(null);
            performanceStatus.setAuditStatus(auditStatus);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
            performanceRelations.setCreatedAt(null);
            performanceRelations.setUpdatedAt(updatedAt);

            performancesMapper.update(performances, new UpdateWrapper<KylinPerformances>().eq("performances_id", performances.getPerformancesId()));
            performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performances.getPerformancesId()));
            performanceRelationsMapper.update(performanceRelations, new UpdateWrapper<KylinPerformanceRelations>().eq("performance_id", performances.getPerformancesId()));


            //场次数据
            List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (KylinTicketTimesPartnerVo ticketTimeItem : kylinTicketTimesPartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(null);
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(null);
                ticketTimeRelation.setUpdatedAt(updatedAt);

                if (ticketTimeItem.getStatus() == -1) {
                    ticketTimes.setStatus(1);
                    ticketTimesMapper.insert(ticketTimes);
                    ticketTimeRelationMapper.insert(ticketTimeRelation);

                    KylinTicketTimesVo kylinTicketTimesVo = new KylinTicketTimesVo();
                    kylinTicketTimesVo.setTicketTimes(ticketTimes);
                    kylinTicketTimesVo.setPerformanceId(ticketTimeRelation.getPerformanceId());
                    kylinTicketTimesVo.setTimeId(ticketTimeRelation.getTimesId());

//                    HashMap<String ,Object> map2 = new HashMap<>();
//                    map2.put("status",1);
//                    BasicDBObject obj = new BasicDBObject("$set", mongoConverter.convertToMongoType(map2));
//                    mongoTemplate.getCollection(TicketTimesPartnerVo.class.getSimpleName()).updateOne(
//                            Query.query(Criteria.where("ticketTimesId").is(ticketTimes.getTicketTimesId())).getQueryObject(),
//                            obj
//                    );

                    boolean ticketTimesExists =
                            mongoTemplate.exists(Query.query(Criteria.where("ticketTimesId").is(kylinTicketTimesVo.getTicketTimesId())), KylinTicketTimesVo.class, KylinTicketTimesVo.class.getSimpleName());
                    if (!ticketTimesExists) {
                        mongoTemplate.insert(
                                kylinTicketTimesVo, KylinTicketTimesVo.class.getSimpleName()
                        );
                    }

                } else {
                    ticketTimesMapper.update(ticketTimes, new UpdateWrapper<KylinTicketTimes>().eq("ticket_times_id", ticketTimes.getTicketTimesId()));
                    ticketTimeRelationMapper.update(ticketTimeRelation, new UpdateWrapper<KylinTicketTimeRelation>().eq("times_id", ticketTimes.getTicketTimesId()));
                }

                //修改票
                for (KylinTicketPartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    KylinTicketPartnerVo kylinTicketPartnerVo;
                    kylinTicketPartnerVo = mongoTemplate.findOne(
                            Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())),
                            KylinTicketPartnerVo.class,
                            KylinTicketPartnerVo.class.getSimpleName()
                    );

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketRelations);

                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    if (ticketItem.getIsExpress() == 1) {
                        tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                    }
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setUpdatedAt(updatedAt);

                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                    ticketStatus.setTicketId(tickets.getTicketsId());

                    ticketStatus.setStatusExchange(7);
                    if (ticketItem.getIsShowCode() == 1) {
                        ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));
                    }

                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setUpdatedAt(updatedAt);

                    if (ticketItem.getStatus() == -2) {

//                        ticketStatus.setLimitCount(null);
//                        ticketStatus.setTotalGeneral(null);
//                        ticketStatus.setTotalExchange(null);
//                        tickets.setTimeStart(null);
//                        tickets.setTimeEnd(null);
                        tickets.setAdvanceMinuteMember(5);
                        ticketStatus.setIsMember(1);
                        ticketRelations.setCreatedAt(LocalDateTime.now());
                        tickets.setCreatedAt(LocalDateTime.now());

                        ticketsMapper.insert(tickets);
                        ticketStatus.setStatus(9);
                        ticketStatusMapper.insert(ticketStatus);
                        ticketRelationsMapper.insert(ticketRelations);

                        KylinTicketVo kylinTicketVo = new KylinTicketVo();
                        kylinTicketVo.setTimeId(ticketRelations.getTimesId());
                        kylinTicketVo.setTicket(tickets);
                        kylinTicketVo.setTicketStatus(ticketStatus);

                        dataUtils.setSurplusExchange(kylinTicketVo.getTicketsId(), ticketStatus.getSurplusExchange());
                        dataUtils.setSurplusGeneral(kylinTicketVo.getTicketsId(), ticketStatus.getSurplusGeneral());


                        BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                        mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).updateOne(
                                Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                                objectTicketVo
                        );
                        boolean ticketExists =
                                mongoTemplate.exists(Query.query(Criteria.where("ticketsId").is(kylinTicketVo.getTicketsId())), KylinTicketVo.class, KylinTicketVo.class.getSimpleName());
                        if (!ticketExists) {
                            mongoTemplate.insert(
                                    kylinTicketVo, KylinTicketVo.class.getSimpleName()
                            );
                        }

                    } else {
                        //不改动数据 价格 限购 购票时间
                        ticketStatus.setLimitCount(null);
                        ticketStatus.setTotalGeneral(null);
                        ticketStatus.setTotalExchange(null);
                        tickets.setTimeStart(null);
                        tickets.setTimeEnd(null);
                        ticketStatus.setCounts(null);
                        ticketStatus.setIsMember(null);
                        ticketRelations.setCreatedAt(null);
                        tickets.setCreatedAt(null);

                        ticketsMapper.update(tickets, new UpdateWrapper<KylinTickets>().eq("tickets_id", tickets.getTicketsId()));
                        ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", tickets.getTicketsId()));
                        ticketRelationsMapper.update(ticketRelations, new UpdateWrapper<KylinTicketRelations>().eq("ticket_id", tickets.getTicketsId()));
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
