package com.liquidnet.client.admin.zhengzai.stone.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.param.StoneItemBuildParam;

import java.util.List;

public interface IItemService {

    /**
     * 获取 积分商品 列表
     *
     * @param title  名称
     * @param status 状态[-999-全部|1-上架中|2-待上架|7-已下架]
     * @param type   类型[1-券]
     * @return
     */
    PageInfo<StoneScoreItems> itemList(String title, Integer status, Integer type, Integer simpleType);

    /**
     * 修改 积分物品 状态
     *
     * @param itemId ID
     * @param status 状态[-1-删除|1-上架|7-下架]
     * @return
     */
    String changeStatus(String itemId, Integer status);

    /**
     * 获取 积分物品 详情
     *
     * @param itemId ID
     * @return
     */
    StoneScoreItems itemDetails(String itemId);

    String createItem(StoneItemBuildParam param);

    String updateItem(StoneItemBuildParam param);
}
