package com.liquidnet.service.kylin.dto.param.ticketSystem;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldListVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@ApiModel(value = "STUpdateTimesParam",description = "详情")
public class STUpdateTimesParam implements Cloneable{
    @ApiModelProperty(value = "演出场次ID [必传]")
    String sessionId;
    @ApiModelProperty(value = "演出场次编码 [必传]")
    String sessionCode;
    @ApiModelProperty(value = "场次名称 [必传]")
    String sessionName;
    @ApiModelProperty(value = "场次开始时间 [必传]")
    LocalDateTime sessionStartTime;
    @ApiModelProperty(value = "场次结束时间 [必传]")
    LocalDateTime sessionEndTime;
    @ApiModelProperty(value = "场厅编码 [必传]")
    String hallCode;
    @ApiModelProperty(value = " 是否有座，0：无座1：有座 [必传]")
    Integer hasSeat;
    @ApiModelProperty(value = "演出ID [必传]")
    String performanceId;
    @ApiModelProperty(value = "场次状态，1 正常，2 取消 [必传]")
    Integer sessionStatus;
    @ApiModelProperty(value = " 标记，0:正式，1:测试 [非必传]")
    Integer tag;
    @ApiModelProperty(value = "票图URL [有座场次必传]")
    String seatingChart;

    private static final STUpdateTimesParam obj = new STUpdateTimesParam();

    public static STUpdateTimesParam getNew() {
        try {
            return (STUpdateTimesParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STUpdateTimesParam();
    }
}