package com.liquidnet.client.admin.zhengzai.adam.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.core.domain.BaseEntity;

/**
 * 用户对象 adam_user
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
public class AdamUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Integer mid;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String uid;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String mobile;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String passwd;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String payCode;

    /** 1-NORMAL,2-INVALID */
    @Excel(name = "1-NORMAL,2-INVALID")
    private Integer state;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "1-NORMAL,2-INVALID", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "1-NORMAL,2-INVALID", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "1-NORMAL,2-INVALID", width = 30, dateFormat = "yyyy-MM-dd")
    private Date closedAt;

    /** $column.columnComment */
    @Excel(name = "1-NORMAL,2-INVALID")
    private String comment;

    public void setMid(Integer mid) 
    {
        this.mid = mid;
    }

    public Integer getMid() 
    {
        return mid;
    }
    public void setUid(String uid) 
    {
        this.uid = uid;
    }

    public String getUid() 
    {
        return uid;
    }
    public void setMobile(String mobile) 
    {
        this.mobile = mobile;
    }

    public String getMobile() 
    {
        return mobile;
    }
    public void setPasswd(String passwd) 
    {
        this.passwd = passwd;
    }

    public String getPasswd() 
    {
        return passwd;
    }
    public void setPayCode(String payCode) 
    {
        this.payCode = payCode;
    }

    public String getPayCode() 
    {
        return payCode;
    }
    public void setState(Integer state) 
    {
        this.state = state;
    }

    public Integer getState() 
    {
        return state;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }
    public void setClosedAt(Date closedAt) 
    {
        this.closedAt = closedAt;
    }

    public Date getClosedAt() 
    {
        return closedAt;
    }
    public void setComment(String comment) 
    {
        this.comment = comment;
    }

    public String getComment() 
    {
        return comment;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("mid", getMid())
            .append("uid", getUid())
            .append("mobile", getMobile())
            .append("passwd", getPasswd())
            .append("payCode", getPayCode())
            .append("state", getState())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("closedAt", getClosedAt())
            .append("comment", getComment())
            .toString();
    }
}
