package com.liquidnet.service.galaxy.biz;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBindBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyTradeService;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyTradeBiz
 * @Package com.liquidnet.service.galaxy.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/7/11 15:47
 */
@Slf4j
@Component
public class GalaxyTradeBiz {
    @Autowired
    private GalaxyDataUtils dataUtils;

    @Resource(name = "galaxyTradeServiceImpl")
    private IGalaxyTradeService galaxyTradeService;

    /**
     * 根据skuid和nftIndex判断是否切换nft购买订单
     * @param skuid
     * @param nftIndex
     */
    public boolean isNeedSwitch(String skuid,String nftIndex){
        List numsList = dataUtils.getGoblinNumList(skuid);
        if(StringUtil.isNotEmpty(numsList)){
            if(numsList.contains(nftIndex)){
                return true;
            }
        }
        return false;
    }

    /**
     * 根据skuid和nftIndex判断是否切换nft购买订单
     * @param skuid
     * @param nftIndex
     */
    public void switchBuyRouterBySkuId(String skuid, String nftIndex, GalaxySeriesNftInfoBo seriesNftInfoBo){
        GalaxyNftPublishAndBuyReqDto reqDto = dataUtils.getGoblinNumDetails(skuid,nftIndex);

        //设置绑定信息
        GalaxyNftOrderBindBo nftOrderBindBo = GalaxyNftOrderBindBo.getNew();
        nftOrderBindBo.setNftOrderPayId(reqDto.getNftOrderPayId());
        nftOrderBindBo.setSeriesId(seriesNftInfoBo.getSeriesId());
        nftOrderBindBo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
        nftOrderBindBo.setNftIdIndex(Integer.valueOf(nftIndex));
        nftOrderBindBo.setRouterType(reqDto.getRouterType());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        nftOrderBindBo.setCreatedAt(nowTimeStr);
        dataUtils.setGalaxyNftOrderBindBo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBindBo);


        //执行nft购买订单切换
        log.info("开始执行nft购买订单切换===>>>>> reqParam:{}", JsonUtils.toJson(reqDto));
        ResponseDto<GalaxyNftPublishAndBuyRespDto> responseDto = galaxyTradeService.nftPublishAndBuy(reqDto);
        log.info("执行nft购买订单切换结果===>>>>> response:{}",JsonUtils.toJson(responseDto));
    }
}
