package com.liquidnet.service.galaxy.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.biz.GalaxyBeanTransferBiz;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.*;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderFailLogVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftTradeVo;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.MongoTemplate;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 该类为redis+mysql
 */
@Slf4j
public abstract class AbstractDataUtils {
    public abstract RedisUtil getRedisUtil();
    
    public abstract MongoTemplate getMongoTemplate();
    
    public abstract QueueUtil getQueueUtil();

//    private long keyExpireTime = 3600*24*30;

    public void setGalaxyUserInfoByIdCardNo(String routerType,String idCardNo, String address) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_USER_ID_CARD.concat(routerType).concat(":") + idCardNo,address);
    }

    public String getGalaxyUserInfoByIdCardNo(String routerType,String idCardNo) {
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_USER_ID_CARD.concat(routerType).concat(":") + idCardNo);
        if(obj!=null){
            return (String) obj;
        }
        return null;
    }

    public void setGalaxyUserInfo(String routerType,String userId, GalaxyUserInfoBo userInfoBo) {
        String userType = GalaxyEnum.RegisterTypeEnum.PERSON.getCode();
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(routerType).concat(":") + userId,userInfoBo);

//        insert into galaxy_user_info (mid, user_id, user_name, user_type, mobile, id_card_type
//                , id_card, mnemonic, index,user_identification, user_pub_key
//                , user_pri_key, block_chain_address, router_type,created_at, updated_at)
        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_user_info.insert"),
                    new Object[]{userId,userInfoBo.getUserName(),userType,userInfoBo.getMobile(),userInfoBo.getIdCardType()
                            ,userInfoBo.getIdCard(),userInfoBo.getMnemonic(),userInfoBo.getIndex(),userInfoBo.getUserIdentification(),userInfoBo.getUserPubKey()
                            ,userInfoBo.getUserPriKey(),userInfoBo.getBlockChainAddress(),userInfoBo.getRouterType(),new Date(),null
                    }
                    , MQConst.GalaxyQueue.SQL_USER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setGalaxyUserInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public void updateGalaxyUserInfo(String routerType,String userId, GalaxyUserInfoBo userInfoBo) {
        String userType = GalaxyEnum.RegisterTypeEnum.PERSON.getCode();
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(routerType).concat(":") + userId,userInfoBo);

//      update galaxy_user_info set user_name = ?,id_card_type = ?,id_card = ?,mobile = ?,block_chain_address = ? where router_type = ? and user_id = ?
        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_user_info.update"),
                    new Object[]{userInfoBo.getUserName(),userInfoBo.getIdCardType(),userInfoBo.getIdCard(),userInfoBo.getMobile()
                            ,userInfoBo.getBlockChainAddress(),userInfoBo.getUserIdentification(),new Date(),userInfoBo.getRouterType(),userInfoBo.getUserId()
                    }
                    , MQConst.GalaxyQueue.SQL_USER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setGalaxyUserInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public GalaxyUserInfoBo getGalaxyUserInfo(String routerType,String userId) {
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(routerType).concat(":") + userId);
        if(obj!=null){
            return (GalaxyUserInfoBo) obj;
        }
        return null;
    }

    public void setSeriesNftUploadBo(String routerType,String skuId, GalaxySeriesNftUploadBo seriesNftUploadBo) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT_UPLOAD.concat(routerType).concat(":") + skuId,seriesNftUploadBo);
    }

    public GalaxySeriesNftUploadBo getSeriesNftUploadBo(String routerType,String skuId) {
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT_UPLOAD.concat(routerType).concat(":") + skuId);
        if(obj!=null){
            return (GalaxySeriesNftUploadBo) obj;
        }
        return null;
    }

    public void setSeriesInfoBo(String routerType,String seriesCode, GalaxySeriesInfoBo seriesInfoBo) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES.concat(routerType).concat(":") + seriesCode,seriesInfoBo);

//        insert into galaxy_series_info (mid, series_info_id, series_name, series_code, series_id, total_count
//                , crt_count,series_claim_task_id, series_claim_status, cover_url, series_desc
//                , nft_count,router_type, created_at, updated_at)
        Integer nftCount = seriesInfoBo.getNftCount();//默认为一个系列包含一个NFT

        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_series_info.insert"),
                    new Object[]{seriesInfoBo.getSeriesInfoId(),seriesInfoBo.getSeriesName(),seriesCode,null,seriesInfoBo.getTotalCount()
                            ,seriesInfoBo.getCrtCount(),seriesInfoBo.getSeriesClaimTaskId(),seriesInfoBo.getSeriesClaimStatus(),seriesInfoBo.getCoverUrl(),seriesInfoBo.getSeriesDesc()
                            ,nftCount,seriesInfoBo.getRouterType(),LocalDateTime.now(),null
                    }
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setSeriesInfoBo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public GalaxySeriesInfoBo getSeriesInfoBo(String routerType, String seriesCode) {
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_SERIES.concat(routerType).concat(":") + seriesCode);
        if(obj!=null){
            return (GalaxySeriesInfoBo) obj;
        }
        return null;
    }

    public void setSeriesNftInfoBo(String routerType, String skuId, GalaxySeriesInfoBo seriesInfoBo, GalaxySeriesNftInfoBo seriesNftInfoBo) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT.concat(routerType).concat(":") + skuId,seriesNftInfoBo);

        //初始化nft发行绑定索引,未发行则初始化为0，
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_NFT.concat(routerType).concat(":").concat(skuId),seriesNftInfoBo.getNftIdBeginIndex()-1);

        try{
//            insert into galaxy_series_nft_info (mid, series_nft_info_id, series_info_id, sku_id, series_name, series_code
//                    ,series_id, nft_total_count, nft_crt_count,nft_id_begin,nft_id_begin_index,nft_publish_number,original_nft_url
//                    , original_display_url,author, nft_name, nft_url, display_url
//                    , nft_desc, nft_flag, sell_count, nft_hash,router_type
//                    , created_at, updated_at)
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_series_nft_info.insert"),
                    new Object[]{seriesNftInfoBo.getSeriesNftInfoId(),seriesInfoBo.getSeriesInfoId(),skuId,seriesInfoBo.getSeriesName(),seriesInfoBo.getSeriesCode()
                            ,seriesInfoBo.getSeriesId(),seriesNftInfoBo.getNftTotalCount(),seriesNftInfoBo.getNftCrtCount(),seriesNftInfoBo.getNftIdBegin(),seriesNftInfoBo.getNftIdBeginIndex(),seriesNftInfoBo.getNftPublishNumber(),seriesNftInfoBo.getOriginalNftUrl()
                            ,seriesNftInfoBo.getOriginalDisplayUrl(),seriesNftInfoBo.getAuthor(),seriesNftInfoBo.getNftName(),seriesNftInfoBo.getNftUrl(),seriesNftInfoBo.getDisplayUrl()
                            ,seriesNftInfoBo.getNftDesc(),seriesNftInfoBo.getNftFlag(),seriesNftInfoBo.getSellCount(),seriesNftInfoBo.getNftHash(),seriesInfoBo.getRouterType()
                            ,LocalDateTime.now(),null
                    }
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey());
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setSeriesInfoBo error ==> MESSAGE:{}",e.getMessage());
        }
    }


    public GalaxySeriesNftInfoBo getSeriesNftInfoBo(String routerType, String skuId) {
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT.concat(routerType).concat(":") + skuId);
        if(obj!=null){
            return (GalaxySeriesNftInfoBo) obj;
        }
        return null;
    }

    public void updateSeriesClaimStatus(String routerType,String seriesCode, GalaxySeriesInfoBo seriesInfoBo,String skuId) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES.concat(routerType).concat(":") + seriesCode,seriesInfoBo);

        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_series_info.updateSeriesIdAndStatus"),
                    new Object[]{seriesInfoBo.getSeriesId(),seriesInfoBo.getChainTimestamp(),seriesInfoBo.getTradeHash(),seriesInfoBo.getSeriesClaimStatus(),nowTimeStr,seriesInfoBo.getSeriesCode()}
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#updateSeriesClaimStatus error ==> MESSAGE:{}",e.getMessage());
        }

        //更新系列对应的系列nft状态
        GalaxySeriesNftInfoBo seriesNftInfoBo = this.getSeriesNftInfoBo(routerType,skuId);
        seriesNftInfoBo.setSeriesId(seriesInfoBo.getSeriesId());
        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
        this.updateSeriesNftStatus(routerType,skuId,seriesNftInfoBo);
    }

    public void updateSeriesClaimStatus(String routerType,String seriesCode, GalaxySeriesInfoBo seriesInfoBo) {
//        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES.concat(routerType).concat(":") + seriesCode,seriesInfoBo);
//
//        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
//        try{
//            this.getQueueUtil().sendMySqlRedis(
//                    SqlMapping.get("galaxy_series_info.updateSeriesIdAndStatus"),
//                    new Object[]{seriesInfoBo.getSeriesId(),seriesInfoBo.getChainTimestamp(),seriesInfoBo.getTradeHash(),seriesInfoBo.getSeriesClaimStatus(),nowTimeStr,seriesInfoBo.getSeriesCode()}
//                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
//            );
//        }catch(Exception e){
//            log.error(e.getMessage(),e);
//            log.error("#updateSeriesClaimStatus error ==> MESSAGE:{}",e.getMessage());
//        }
//
//        //更新系列对应的系列nft状态
//        List<String> skuIdList = this.getSkuIdListBySeriesCode(seriesCode);
//        skuIdList.stream().forEach(skuId -> {
//            GalaxySeriesNftInfoBo seriesNftInfoBo = this.getSeriesNftInfoBo(routerType,skuId);
//            seriesNftInfoBo.setSeriesId(seriesInfoBo.getSeriesId());
//            seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//            this.updateSeriesNftStatus(routerType,skuId,seriesNftInfoBo);
//        });
    }

    public void updateSeriesNftStatus(String routerType,String skuId, GalaxySeriesNftInfoBo seriesNftInfoBo) {
        //更新系列nft状态
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT.concat(routerType).concat(":") + skuId,seriesNftInfoBo);

        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(seriesNftInfoBo.getUpdatedAt());

        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_series_nft_info.updateSeriesIdAndStatus"),
                    new Object[]{seriesNftInfoBo.getSeriesId(),nowTimeStr,seriesNftInfoBo.getSkuId()}
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#updateSeriesNftStatus error ==> MESSAGE:{}",e.getMessage());
        }
    }

    //根据系列Id获取 一个系列对应多个skuId
//    public List<String> getSkuIdListBySeriesCode(String seriesCode){
//        //根据演出id获取用户信息 只查询5条
//        List<String> skuIdList = new ArrayList<>();
//        //获取总数
//        Criteria criteria = Criteria.where("seriesCode").is(seriesCode);
//
//        Query query = Query.query(criteria);
//
//        long startTime = System.currentTimeMillis();
//        List<GalaxySeriesNftInfoVo> seriesNftInfoVoList = this.getMongoTemplate().find(query, GalaxySeriesNftInfoVo.class, GalaxySeriesNftInfoVo.class.getSimpleName());
//        long endTime = System.currentTimeMillis();
//        log.info("getSkuIdListBySeriesCode 根据系列code获取skuId 耗时：{}ms",endTime-startTime);
//
//        //根据用户id获取头像信息
//        if(StringUtil.isNotNull(seriesNftInfoVoList)){
//            skuIdList = seriesNftInfoVoList.stream().map(GalaxySeriesNftInfoVo::getSkuId).collect(Collectors.toList());
//        }
//        return skuIdList;
//    }

    public void setNftOrderBo(String routerType,String nftOrderPayId, GalaxyNftOrderBo nftOrderBo) {

        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_TRADE_ORDER.concat(routerType).concat(":") + nftOrderPayId,nftOrderBo);

//        insert into galaxy_nft_order_info (nft_order_pay_id, user_id, sku_id, series_name, series_id,
//                series_code, nft_id,nft_price, nft_publish_task_id, nft_publish_from_address,
//                nft_publish_to_address,nft_publish_chain_timestamp, nft_publish_status, nft_publish_trade_hash,nft_buy_task_id,
//                nft_buy_from_address, nft_buy_to_address, nft_buy_chain_timestamp,nft_buy_status, nft_buy_trade_hash,
//                nft_buy_pay_task_id, router_type, created_at,updated_at)
        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.insert"),
                    new Object[]{nftOrderPayId,nftOrderBo.getUserId(),nftOrderBo.getSkuId(),nftOrderBo.getSeriesName(),nftOrderBo.getSeriesId()
                            ,nftOrderBo.getSeriesCode(),nftOrderBo.getNftId(),nftOrderBo.getNftName(),nftOrderBo.getNftPrice(),nftOrderBo.getNftPublishTaskId(),nftOrderBo.getNftPublishFromAddress()
                            ,nftOrderBo.getNftPublishToAddress(),nftOrderBo.getNftPublishChainTimestamp(),nftOrderBo.getNftPublishStatus(),nftOrderBo.getNftPublishTradeHash(),nftOrderBo.getNftBuyTaskId()
                            ,nftOrderBo.getNftBuyFromAddress(),nftOrderBo.getNftBuyToAddress(),nftOrderBo.getNftBuyChainTimestamp(),nftOrderBo.getNftBuyStatus(),nftOrderBo.getNftBuyTradeHash(),
                            nftOrderBo.getNftBuyPayTaskId(),nftOrderBo.getRouterType(),LocalDateTime.now(),null
                    }
                    , MQConst.GalaxyQueue.SQL_NFT_ORDER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftOrderBo error ==> MESSAGE:{}",e.getMessage());
        }

        //更新系列已发行信息
        try {
            this.updateSeriesCrtCount(routerType,nftOrderBo.getSeriesCode());
        } catch (Exception e) {
            log.error(e.getMessage(),e);
        }
        //更新系列nft已发行信息
        try {
            this.updateSeriesNftCrtCount(routerType,nftOrderBo.getSkuId());
        } catch (Exception e) {
            log.error(e.getMessage(),e);
        }

    }

    public GalaxyNftOrderBo getNftOrderBo(String routerType, String nftOrderPayId) {
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_TRADE_ORDER.concat(routerType).concat(":") + nftOrderPayId);
        if(obj!=null){
            return (GalaxyNftOrderBo) obj;
        }
        return null;
    }

    /**
     * 更新nft订单发行数据
     * @param routerType
     * @param nftOrderPayId
     * @param nftOrderBo
     */
    public void updateNftOrderPublishInfo(String routerType,String nftOrderPayId,GalaxyNftOrderBo nftOrderBo) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_TRADE_ORDER.concat(routerType).concat(":") + nftOrderPayId,nftOrderBo);

        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.updateNftPublishInfo"),
                    new Object[]{nftOrderBo.getNftId(),nftOrderBo.getNftPublishTaskId(),nftOrderBo.getNftPublishChainTimestamp()
                            ,nftOrderBo.getNftPublishStatus(),nftOrderBo.getNftPublishTradeHash()
                            ,LocalDateTime.now(),nftOrderBo.getNftOrderPayId()}
                    , MQConst.GalaxyQueue.SQL_NFT_ORDER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#updateNftOrderPublishInfo error ==> MESSAGE:{}",e.getMessage());
        }

        if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
            GalaxyNftTradeVo nftTradeVo = GalaxyBeanTransferBiz.buildNftTradeVo(GalaxyEnum.TradeTypeEnum.TRADE_PUBLISH,nftOrderBo);
            this.setNftTradeInfo(routerType,nftTradeVo);
        }
    }

    /**
     * 更新nft订单购买数据
     * @param routerType
     * @param nftOrderPayId
     * @param nftOrderBo
     */
    public void updateNftOrderBuyInfo(String routerType,String nftOrderPayId,GalaxyNftOrderBo nftOrderBo) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_TRADE_ORDER.concat(routerType).concat(":") + nftOrderPayId,nftOrderBo);

        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.updateNftBuyInfo"),
                    new Object[]{nftOrderBo.getNftBuyTaskId(),nftOrderBo.getNftBuyChainTimestamp(),nftOrderBo.getNftBuyStatus()
                            ,nftOrderBo.getNftBuyTradeHash(),nftOrderBo.getNftBuyPayTaskId()
                            ,LocalDateTime.now(),nftOrderBo.getNftOrderPayId()}
                    , MQConst.GalaxyQueue.SQL_NFT_ORDER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftTradeInfo error ==> MESSAGE:{}",e.getMessage());
        }

        if(nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
            GalaxyNftTradeVo nftTradeVo = GalaxyBeanTransferBiz.buildNftTradeVo(GalaxyEnum.TradeTypeEnum.TRADE_BUY,nftOrderBo);
            this.setNftTradeInfo(routerType,nftTradeVo);
        }
    }

    public void setGalaxyNftOrderBindBo(String routerType,String nftOrderPayId, GalaxyNftOrderBindBo nftOrderBindBo) {
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_ORDER.concat(routerType).concat(":") + nftOrderPayId,nftOrderBindBo);
    }

    public GalaxyNftOrderBindBo getGalaxyNftOrderBindBo(String routerType,String nftOrderPayId) {
        String redisKey = GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_ORDER.concat(routerType).concat(":") + nftOrderPayId;
        Object obj = this.getRedisUtil().get(redisKey);
        if(obj!=null){
            return (GalaxyNftOrderBindBo) obj;
        }
        return null;
    }

    public void setNftTradeInfo(String routerType, GalaxyNftTradeVo nftTradeVo) {
        try{
//            insert into galaxy_nft_trade_info (user_id, nft_id, nft_name, series_name, series_id,
//                    series_code, trade_hash,chain_timestamp, from_address, to_address,
//                    trade_price, trade_type, router_type,created_at, updated_at)
            /**
             * 发行成功记录入库mysql
             */
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_trade_info.insert"),
                    new Object[]{nftTradeVo.getUserId(),nftTradeVo.getNftId(),nftTradeVo.getNftName(),nftTradeVo.getSeriesName(),nftTradeVo.getSeriesId(),
                            nftTradeVo.getSeriesCode(),nftTradeVo.getTradeHash(),nftTradeVo.getChainTimestamp(),nftTradeVo.getFromAddress(),nftTradeVo.getToAddress(),
                            nftTradeVo.getTradePrice(),nftTradeVo.getTradeType(),nftTradeVo.getRouterType(),LocalDateTime.now(),nftTradeVo.getUpdatedAt()}
                    , MQConst.GalaxyQueue.SQL_NFT_TRADE_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftTradeInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public void setNftOrderFailLogVo(String routerType, GalaxyNftOrderFailLogVo nftOrderFailLogVo) {
//        insert into galaxy_nft_order_fail_log (nft_order_pay_id, user_id, nft_id, nft_name, series_name,
//                                              series_id,series_code, taskId, fail_reason_desc, fail_reason_desc_second,
//                                              deal_with_status,trade_type, router_type, created_at, updated_at)
        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_fail_log.insert"),
                    new Object[]{nftOrderFailLogVo.getNftOrderPayId(),nftOrderFailLogVo.getUserId(),nftOrderFailLogVo.getNftId(),nftOrderFailLogVo.getNftName(),nftOrderFailLogVo.getSeriesName(),
                            nftOrderFailLogVo.getSeriesId(),nftOrderFailLogVo.getSeriesCode(),nftOrderFailLogVo.getTaskId(),nftOrderFailLogVo.getFailReasonDesc(),nftOrderFailLogVo.getFailReasonDescSecond(),
                            nftOrderFailLogVo.getDealWithStatus(),nftOrderFailLogVo.getTradeType(),nftOrderFailLogVo.getRouterType(),LocalDateTime.now(),null
                    }
                    , MQConst.GalaxyQueue.SQL_NFT_ORDER_FAIL_LOG.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftOrderFailLogVo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public long incrNftIdNo(String routerType,String skuId) {
        return this.getRedisUtil().incr(GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_NFT.concat(routerType).concat(":").concat(skuId), 1);
    }

    public long getNftIdNo(String routerType,String skuId) {
        Object o = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_NFT.concat(routerType).concat(":").concat(skuId));
        return o==null?-1:(int)o;
    }

    /**
     * 更新系列已购买信息
     * @param routerType
     * @param seriesCode
     */
    public void updateSeriesCrtCount(String routerType,String seriesCode) {
        GalaxySeriesInfoBo seriesInfoBo = this.getSeriesInfoBo(routerType,seriesCode);
        seriesInfoBo.setCrtCount(seriesInfoBo.getCrtCount()+1);
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES.concat(routerType).concat(":") + seriesCode,seriesInfoBo);

        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_series_info.updateSeriesCrtCount"),
                    new Object[]{seriesInfoBo.getCrtCount(),LocalDateTime.now(),seriesCode}
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#updateSeriesCrtCount error ==> MESSAGE:{}",e.getMessage());
        }
    }

    /**
     * 更新系列nft已购买信息
     * @param routerType
     * @param skuId
     */
    public void updateSeriesNftCrtCount(String routerType,String skuId) {
        GalaxySeriesNftInfoBo seriesNftInfoBo = this.getSeriesNftInfoBo(routerType,skuId);
        seriesNftInfoBo.setNftCrtCount(seriesNftInfoBo.getNftCrtCount()+1);
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT.concat(routerType).concat(":") + skuId,seriesNftInfoBo);

        try{
            this.getQueueUtil().sendMySqlRedis(
                    SqlMapping.get("galaxy_series_nft_info.updateSeriesNftCrtCount"),
                    new Object[]{seriesNftInfoBo.getNftCrtCount(),LocalDateTime.now(),skuId}
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#GalaxySeriesNftInfoBo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public void setSeriesNftUploadTempSecretBo(String uploadSeriesName,GalaxySeriesNftUploadTempSecretBo seriesNftUploadTempSecretBo){
        long keyExpireTime = 320;
        this.getRedisUtil().set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT_UPLOAD_TEMP_SECRET.concat(":") + uploadSeriesName,seriesNftUploadTempSecretBo,keyExpireTime);
    }

    public GalaxySeriesNftUploadTempSecretBo getSeriesNftUploadTempSecretBo(String uploadSeriesName){
        Object obj = this.getRedisUtil().get(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT_UPLOAD_TEMP_SECRET.concat(":") + uploadSeriesName);
        if(obj!=null){
            return (GalaxySeriesNftUploadTempSecretBo) obj;
        }else{
            return null;
        }
    }


    //获取sku对应预留号码list
    public List<String> getGoblinNumList(String skuId){
        String redisKey = GoblinRedisConst.GOBLIN_NUM_LIST.concat(skuId);
        Object obj = this.getRedisUtil().get(redisKey);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) obj;
        }
    }

    //$key+$num+$skuId 根据num+skuId获取DTO
    public GalaxyNftPublishAndBuyReqDto getGoblinNumDetails(String skuId, String nftIndex){
        String redisKey = GoblinRedisConst.GOBLIN_NUM_DETAILS.concat(nftIndex).concat(skuId);
        Object obj = this.getRedisUtil().get(redisKey);
        if(obj!=null){
            return (GalaxyNftPublishAndBuyReqDto)obj;
        }
        return null;
    }
}
