package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author TT
 */
@ApiModel(value = "UserData", description = "代理数据")
@Data
public class UserData implements Serializable, Cloneable {

    /**
     * 用户uid
     */
    @ApiModelProperty(value = "用户uid", example = "")
    private String uid;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", example = "")
    private String username;

    /**
     * 城市名称
     */
    @ApiModelProperty(value = "城市名称", example = "")
    private String cityName;

    /**
     * 身份   1。总代  2.普代
     */
    @ApiModelProperty(value = "身份   1。总代  2.普代", example = "")
    private Integer type;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码", example = "")
    private String phone;

    /**
     * 城市名称
     */
    @ApiModelProperty(value = "总代姓名", example = "")
    private String agentName;

    /**
     * 用户代理票信息
     */
    @ApiModelProperty(value = "用户代理票信息", example = "")
    List<UserDataAgentVo> dataAgentVos;

    /**
     * 打款状态
     */
    @ApiModelProperty(value = "打款状态", example = "")
    private Integer priceStatus;

    @ApiModelProperty(value = "总佣金")
    private BigDecimal totalCommission;


    private static final UserData obj = new UserData();

    public static UserData getNew() {
        try {
            return (UserData) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new UserData();
    }
}
