package com.liquidnet.client.admin.web.vo.adam.transaction;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.annotation.Excel.ColumnType;
import com.liquidnet.client.admin.common.annotation.Excel.Type;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel
public class AdamConversionRecordVo implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    @ApiModelProperty("订单号")
    @Excel(name = "Transaction ID", cellType = ColumnType.NUMERIC, prompt = "订单号")
    private String transactionId;

    @ApiModelProperty("卖方账号")
    @Excel(name = "From Wallet")
    private String fromWallet;

    @ApiModelProperty("买方账号")
    @Excel(name = "To Wallet")
    private String toWallet;

    @ApiModelProperty("卖方币种")
    @Excel(name = "Sold Currency")
    private String soldCurrency;

    @ApiModelProperty("卖方金额")
    @Excel(name = "Sole Amount")
    private String soldAmount;

    @ApiModelProperty("买方币种")
    @Excel(name = "Bought Currency")
    private String boughtCurrency;

    @ApiModelProperty("买方金额")
    @Excel(name = "Bought Amount")
    private String boughtAmount;

    @ApiModelProperty("汇率")
    @Excel(name = "Exchange Rate")
    private String exchangeRate;

    @ApiModelProperty("创建日期")
    @Excel(name = "Create Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String createDate;

    @ApiModelProperty("完成日期")
    @Excel(name = "Completed Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String completedDate;

    @ApiModelProperty("换汇日期")
    @Excel(name = "Conversion Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String conversionDate;

    @ApiModelProperty("处理日期")
    @Excel(name = "Settlement Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String settlementDate;

    @ApiModelProperty("交易状态")
    @Excel(name = "Transaction Status", readConverterExp = "ready_to_settle=ready to settle,failed=Failed,completed=Completed")
    private String transactionStatus;

    @ApiModelProperty("错误描述")
    @Excel(name = "Error message")
    private String errorMessage;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getFromWallet() {
        return fromWallet;
    }

    public void setFromWallet(String fromWallet) {
        this.fromWallet = fromWallet;
    }

    public String getToWallet() {
        return toWallet;
    }

    public void setToWallet(String toWallet) {
        this.toWallet = toWallet;
    }

    public String getSoldCurrency() {
        return soldCurrency;
    }

    public void setSoldCurrency(String soldCurrency) {
        this.soldCurrency = soldCurrency;
    }

    public String getSoldAmount() {
        return soldAmount;
    }

    public void setSoldAmount(String soldAmount) {
        this.soldAmount = soldAmount;
    }

    public String getBoughtCurrency() {
        return boughtCurrency;
    }

    public void setBoughtCurrency(String boughtCurrency) {
        this.boughtCurrency = boughtCurrency;
    }

    public String getBoughtAmount() {
        return boughtAmount;
    }

    public void setBoughtAmount(String boughtAmount) {
        this.boughtAmount = boughtAmount;
    }

    public String getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(String completedDate) {
        this.completedDate = completedDate;
    }

    public String getConversionDate() {
        return conversionDate;
    }

    public void setConversionDate(String conversionDate) {
        this.conversionDate = conversionDate;
    }

    public String getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(String settlementDate) {
        this.settlementDate = settlementDate;
    }

    public String getTransactionStatus() {
        return transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
