package com.liquidnet.client.admin.web.vo.adam.transaction;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.annotation.Excel.ColumnType;
import com.liquidnet.client.admin.common.annotation.Excel.Type;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel
public class AdamPayoutRecordVo implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    @ApiModelProperty("订单号")
    @Excel(name = "Transaction ID", cellType = ColumnType.NUMERIC, prompt = "订单号")
    private String transactionId;

    private String orderId;

    @ApiModelProperty("账号")
    @Excel(name = "Wallet No")
    private String walletNo;

    @ApiModelProperty("币种")
    @Excel(name = "Currency")
    private String currency;

    @ApiModelProperty("交易金额")
    @Excel(name = "Transaction Amount")
    private String transactionAmount;

    @ApiModelProperty("交易日期")
    @Excel(name = "Create Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String transactionDate;

    @ApiModelProperty("结束日期")
    @Excel(name = "Execution Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String executionDate;

    @ApiModelProperty("交易状态")
    @Excel(name = "Transaction Status", readConverterExp = "ready_to_process=Ready to Process,awaiting_funds=Awaiting Funds,processing=Processing,cancelled=Cancelled,failed=Failed,completed=Completed")
    private String transactionStatus;

    @ApiModelProperty("是否有换汇牌价")
    @Excel(name = "Payout with FX")
    private String payoutWithFx;

    @ApiModelProperty("换汇牌价")
    @Excel(name = "FX Contract No")
    private String fxContractNo;

    @ApiModelProperty("汇率")
    @Excel(name = "FX Quote")
    private String fxQuote;

    @ApiModelProperty("交易用途")
    @Excel(name = "Payment Purpose")
    private String paymentPurpose;

    @ApiModelProperty("交易说明")
    @Excel(name = "Payment Reference")
    private String paymentReference;

    @ApiModelProperty("错误描述")
    @Excel(name = "Error message")
    private String errorMessage;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(String transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public String getTransactionDate() {
        return transactionDate;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getExecutionDate() {
        return executionDate;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public String getTransactionStatus() {
        return transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getPayoutWithFx() {
        return payoutWithFx;
    }

    public void setPayoutWithFx(String payoutWithFx) {
        this.payoutWithFx = payoutWithFx;
    }

    public String getFxContractNo() {
        return fxContractNo;
    }

    public void setFxContractNo(String fxContractNo) {
        this.fxContractNo = fxContractNo;
    }

    public String getFxQuote() {
        return fxQuote;
    }

    public void setFxQuote(String fxQuote) {
        this.fxQuote = fxQuote;
    }

    public String getPaymentPurpose() {
        return paymentPurpose;
    }

    public void setPaymentPurpose(String paymentPurpose) {
        this.paymentPurpose = paymentPurpose;
    }

    public String getPaymentReference() {
        return paymentReference;
    }

    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
}
