package com.liquidnet.service.kylin.service.impl.partner;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.dto.param.PerformanceStep2Param;
import com.liquidnet.service.kylin.dto.vo.TicketTimesVo;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.service.kylin.service.partner.IKylinPerformancesPartnerService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
public class KylinPerformancesPartnerServiceImpl extends ServiceImpl<KylinPerformancesMapper, KylinPerformances> implements IKylinPerformancesPartnerService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Override
    public String createStep1(PerformanceStep1Param step1Param) {
        // 获取 主键id
        String performanceId = IDGenerator.nextSnowId().toString();
        // 获取 当前时间 -> 创建时间
        LocalDateTime createdAt = LocalDateTime.now();

        try {
            step1Param.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            step1Param.setPerformancesId(performanceId);
            PerformanceStep1Param data = mongoTemplate.insert(
                    step1Param, PerformanceStep1Param.class.getSimpleName()
            );
            return performanceId;
        } catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean createStep2(PerformanceStep2Param step2Param) {

        // 获取 主键id
        String performanceId = step2Param.getPerformancesId();
        // 获取 当前时间 -> 创建时间
        LocalDateTime createdAt = LocalDateTime.now();

        // 获取第一步数据
        if (step2Param.getIsSubmit() == 1) { // 提交
            PerformanceStep1Param info = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)),
                    PerformanceStep1Param.class,
                    PerformanceStep1Param.class.getSimpleName());

            PerformanceCreateParam isExists = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)),
                    PerformanceCreateParam.class,
                    PerformanceCreateParam.class.getSimpleName());
            if(isExists!=null){
                return false;
            }

            // 提交 演出
            PerformanceCreateParam performanceCreateParam = new PerformanceCreateParam();
            BeanUtils.copyProperties(info, performanceCreateParam);
            performanceCreateParam.setIsTrueName(step2Param.getIsTrueName());
            performanceCreateParam.setLimitCount(step2Param.getLimitCount());
            performanceCreateParam.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            performanceCreateParam.setStatus(1);
            PerformanceCreateParam data = mongoTemplate.insert(
                    performanceCreateParam, PerformanceCreateParam.class.getSimpleName()
            );

            //提交 票
            List<TicketTimesVo> ticketTimesVoList = ticketTimesPartnerService.getTimesMongo(performanceId);
            for (TicketTimesVo ticketTimes : ticketTimesVoList) {
                ticketsPartnerService.submitTicketByTimes(ticketTimes.getTicketTimesId());
            }
        } else { //保存
            return false;
        }

        return true;
    }
}
