package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;


/**
 * <p>
 * banner返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
public class BannersVo implements Serializable {
    @ApiModelProperty(value = "Banner主键ID")
    private String bannersId;

    @ApiModelProperty(value = "标题")
    @NotBlank(message = "请填写标题")
    private String name;

    @ApiModelProperty(value = "封面图")
    @NotBlank(message = "请上传封面图")
    private String coverImg;

    @ApiModelProperty(value = "跳转目标id或者url")
    @NotBlank(message = "请填写需要跳转的目标id或urk")
    private String targetId;

    @ApiModelProperty(value = "跳转类型 6演出跳转 7商品跳转 8巡演跳转 12展示分享按钮的web连接 14积分商品详情 100活动跳转 999不跳转 998个人信息跳转")
    @Min(value = 1, message = "请选择跳转类型")
    private Integer type;

    @ApiModelProperty(value = "是否显示 0-否,1-是")
    @Min(value = 1, message = "请选择是否显示")
    private Integer isShow;

    @ApiModelProperty(value = "展示位置")
    @Min(value = 1, message = "请选择展示的位置")
    private Integer position;

    @ApiModelProperty(value = "排序权重 越大越靠前")
    private Integer sort;

    @ApiModelProperty(value = "备注")
    private String comment;

    @ApiModelProperty(value = "是否删除 0已删除,1正常")
    private Integer isDeleted;

    @ApiModelProperty(value = "创建时间")
    private String  createdAt;

    @ApiModelProperty(value = "修改时间")
    private String updatedAt;

}
