package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 场次
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinTicketTimes implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * ticket_times_id
     */
    private String ticketTimesId;

    /**
     * 标题
     */
    private String title;

    /**
     * 0不可用 1可用
     */
    private int status;

    /**
     * 1单日票 2通票
     */
    private int type;

    /**
     * 售票开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 售票结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;


}
