package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Arrays;
import java.util.List;

@ApiModel(value = "AdamMemberRightsVo", description = "会员")
@Data
public class AdamMemberRightsVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -2407106925001008460L;
    @ApiModelProperty(position = 0, value = "权益封面[255]")
    private String cover;
    @ApiModelProperty(position = 1, value = "权益名称[10]")
    private String name;
    @ApiModelProperty(position = 2, value = "展示顺序[2]")
    private Integer sort;

    private static final AdamMemberRightsVo obj = new AdamMemberRightsVo();

    public static AdamMemberRightsVo getNew() {
        try {
            return (AdamMemberRightsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberRightsVo();
    }

    public AdamMemberRightsVo setCover(String cover) {
        this.cover = cover;
        return this;
    }

    public AdamMemberRightsVo setName(String name) {
        this.name = name;
        return this;
    }

    public AdamMemberRightsVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    public List<AdamMemberRightsVo> initDefault() {
        return Arrays.asList(AdamMemberRightsVo.getNew().setName("专属").setSort(1)
                        .setCover("https://img.zhengzai.tv/files/2020/08/28/5f490c4477d72.png"),
                AdamMemberRightsVo.getNew().setName("优惠").setSort(2)
                        .setCover("https://img.zhengzai.tv/files/2020/08/28/5f490c685e7a8.png"),
                AdamMemberRightsVo.getNew().setName("优先").setSort(3)
                        .setCover("https://img.zhengzai.tv/files/2020/08/28/5f490c726a750.png"),
                AdamMemberRightsVo.getNew().setName("专属").setSort(4)
                        .setCover("https://img.zhengzai.tv/files/2020/08/28/5f490c5de2870.png")
        );
    }
}
