package com.liquidnet.service.adam.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class DateUtil {

    /**
     * 前端显示转换的时间戳
     *
     * @param now LocalDate
     *            LocalDateTime
     */
    public static String getVoTimestamp(Object now) {
        return getVoTimestamp(now, ZoneOffset.UTC);
    }

    public static String getVoTimestamp(Object now, ZoneOffset offset) {

        if (now == null) {
            return null;
        }
        if (offset == null) {
            offset = ZoneOffset.UTC;
        }
        long l = 0;
        if (now instanceof LocalDate) {
            l = ((LocalDate) now).atStartOfDay(offset).toInstant().getEpochSecond();
        } else if (now instanceof LocalDateTime) {
            l = ((LocalDateTime) now).toEpochSecond(offset);
        }

        return String.valueOf(l);
    }

    /**
     * 获取当天剩余秒数
     *
     * @param currentDate 当前时间
     */
    public static Integer getRemainSecondsOneDay(Date currentDate) {
        LocalDateTime midnight = LocalDateTime.ofInstant(currentDate.toInstant(),
                ZoneId.systemDefault()).plusDays(1).withHour(0).withMinute(0)
                .withSecond(0).withNano(0);
        LocalDateTime currentDateTime = LocalDateTime.ofInstant(currentDate.toInstant(),
                ZoneId.systemDefault());
        long seconds = ChronoUnit.SECONDS.between(currentDateTime, midnight);
        return (int) seconds;
    }

}
