package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyArtSeriesClaimResultQueryReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 10:51
 */
@ApiModel(value = "GalaxyArtSeriesClaimResultQueryReqDto", description = "NFT系列声明结果查询")
@Data
public class GalaxyArtSeriesClaimResultQueryReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "系列唯一id标识，不超过20个字符")
    @NotBlank(message = "skuId不能为空！")
    @Size(min = 2, max = 20, message = "skuId限制2-20位且不能包含特殊字符")
    private String skuId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyArtSeriesClaimResultQueryReqDto obj = new GalaxyArtSeriesClaimResultQueryReqDto();

    public static GalaxyArtSeriesClaimResultQueryReqDto getNew() {
        try {
            return (GalaxyArtSeriesClaimResultQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyArtSeriesClaimResultQueryReqDto();
        }
    }
}
