package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import lombok.Data;

import java.io.Serializable;

@Data
public class ActiveTicketExportVo implements Serializable, Cloneable {

    @Excel(name = "券码", cellType = Excel.ColumnType.STRING)
    private String code;
    /**
     * 兑换码状态 1未兑换 2已兑换 3已失效
     */
    @Excel(name = "兑换码状态", cellType = Excel.ColumnType.STRING)
    private String state;

    /**
     * 兑换用户id
     */
    @Excel(name = "兑换用户id", cellType = Excel.ColumnType.STRING)
    private String redeemUid;


    private static final ActiveTicketExportVo obj = new ActiveTicketExportVo();

    public static ActiveTicketExportVo getNew() {
        try {
            return (ActiveTicketExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new ActiveTicketExportVo();
    }



}
