package com.liquidnet.service.platform.controller.sweet;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.stone.api.FeignStoneIntegralClient;
import com.liquidnet.service.sweet.dto.SweetWechatUsersDoTaskDto;
import com.liquidnet.service.sweet.mapper.SweetWechatUsersMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 关注任务加积分脚本
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-12-28
 */
@Api(tags = "关注任务加积分")
@Slf4j
@RestController
@RequestMapping("followDoTask")
public class TaskController {

    @Autowired
    private SweetWechatUsersMapper usersMapper;

    @Autowired
    private FeignStoneIntegralClient feignStoneIntegralClient;

    @GetMapping("doTask")
    @ApiOperation("关注任务加积分")
    public ResponseDto<String> doTask() {
        int size = 1000;

        int doCount = usersMapper.selectListDoCount();

        // 总page
        int countPage = (int) Math.ceil(doCount / size);
        countPage = countPage + 1;

        for (int page = 0; page < countPage; page++) {
            List<SweetWechatUsersDoTaskDto> users = usersMapper.selectListDo(size);
            for (SweetWechatUsersDoTaskDto user : users) {
                try {
                    log.info("批量处理领取关注公众号积分params：[uid={}]", user.getUserId());
                    ResponseDto<HashMap<String, Object>> hashMapResponseDto = feignStoneIntegralClient.doTask(4, user.getUserId());
                    log.info("批量处理领取关注公众号积分处理结果：[{}] ", hashMapResponseDto.getData());
                } catch (Exception e) {
                    log.info("批量处理领取关注公众号积分失败：[errorMsg=[{}], [uid=[{}]", e.getMessage(), user.getUserId());
                }
            }
        }
        return ResponseDto.success("success");
    }

}