package com.liquidnet.service.goblin.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontCubeParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 魔方id
     */
    @ApiModelProperty(value = "魔方id")
    private String cubeId;

    /**
     * 1、一行一个2一行二个3一行三个4上一下三
     */
    @ApiModelProperty(value = "1、一行一个2一行二个3一行三个4上一下三")
    private Integer rowType;

    /**
     * 1、单商品2、合集
     */
    @ApiModelProperty(value = "1、单商品2、合集")
    private Integer pageType;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String spuName;

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private String spuId;

    /**
     * 推荐文案
     */
    @ApiModelProperty(value = "推荐文案1")
    private String informationA;
    @ApiModelProperty(value = "推荐文案2")
    private String informationB;
    @ApiModelProperty(value = "推荐文案3")
    private String informationC;
    @ApiModelProperty(value = "推荐文案4")
    private String informationD;


    /**
     * 合集id
     */
    @ApiModelProperty(value = "合集ids")
    private String compilationsId;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;
    /**
     * spu
     */
    @ApiModelProperty(value = "spu信息")
    private GoblinGoods goblinGoods;


}
