package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreGoodsCategoryVo", description = "店铺商品分类")
@Data
public class GoblinStoreGoodsCategoryVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -9043528667634548144L;
    @ApiModelProperty(position = 11, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 12, value = "分类ID")
    private String cateId;
    @ApiModelProperty(position = 13, value = "分类名称")
    private String name;
    @ApiModelProperty(position = 14, value = "排序[数值越小,排序越前]")
    private Integer sort;
    @ApiModelProperty(position = 15, value = "分类层级[1-一级|2-二级|3-三级]")
    private String grade;
    @ApiModelProperty(position = 16, value = "父级分类ID")
    private String catePid;
    @ApiModelProperty(position = 17, value = "是否需要填写ISBN[0-否|1-是]")
    private String neIsbn;
    @ApiModelProperty(position = 18, value = "删除标记[0-未删除|1-删除]")
    private String delFlg;

    public GoblinStoreGoodsCategoryVo setStoreId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setCateId(String cateId) {
        this.cateId = cateId;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setName(String name) {
        this.name = name;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setGrade(String grade) {
        this.grade = grade;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setCatePid(String catePid) {
        this.catePid = catePid;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setNeIsbn(String neIsbn) {
        this.neIsbn = neIsbn;
        return this;
    }

    public GoblinStoreGoodsCategoryVo setDelFlg(String delFlg) {
        this.delFlg = delFlg;
        return this;
    }

    private static final GoblinStoreGoodsCategoryVo obj = new GoblinStoreGoodsCategoryVo();

    public static GoblinStoreGoodsCategoryVo getNew() {
        try {
            return (GoblinStoreGoodsCategoryVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreGoodsCategoryVo();
        }
    }
}
