DROP TABLE IF EXISTS `goblin_list`;
CREATE TABLE `goblin_list`
(
    `mid`         bigint UNSIGNED NOT NULL AUTO_INCREMENT,
    `list_id`     varchar(64)          DEFAULT '' COMMENT '名单id',
    `uid`         varchar(64)          DEFAULT '' COMMENT '用户id',
    `name`        varchar(64)          DEFAULT '' COMMENT '名单名称',
    `white_type`  int                  DEFAULT 1 COMMENT '白名单类型[0-会员|1-指定用户]',
    `white_url`   varchar(512)         DEFAULT '' COMMENT '白名单xls地址',
    `advance_min` int                  DEFAULT 0 COMMENT '提前购买时间',
    `black_type`  int                  DEFAULT 1 COMMENT '黑名单类型[0-会员|1-指定用户]',
    `black_url`   varchar(512)         DEFAULT '' COMMENT '黑名单xls地址',
    `comment`     varchar(255)         DEFAULT '' COMMENT '补充字段',
    `created_at`  datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`  datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '商城-名单表'
  ROW_FORMAT = DYNAMIC;


DROP TABLE IF EXISTS `goblin_list_details`;
CREATE TABLE `goblin_list_details`
(
    `mid`        bigint UNSIGNED NOT NULL AUTO_INCREMENT,
    `list_id`    varchar(64)          DEFAULT '' COMMENT '名单id',
    `spu_id`     varchar(64)          DEFAULT '' COMMENT 'spuId',
    `sku_id`     varchar(64)          DEFAULT '' COMMENT 'skuId',
    `comment`    varchar(255)         DEFAULT '' COMMENT '补充字段',
    `created_at` datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '商城-名单详情表'
  ROW_FORMAT = DYNAMIC;