package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinListDetailsItemVo;
import com.liquidnet.service.goblin.dto.vo.GoblinListDetailsVo;
import com.liquidnet.service.goblin.param.GoblinListCreateItemParam;
import com.liquidnet.service.goblin.param.GoblinListCreateParam;
import com.liquidnet.service.goblin.param.GoblinListUpdateParam;
import com.liquidnet.service.goblin.service.manage.IGoblinListService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 商城-名单表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-29
 */
@Service
public class GoblinListServiceImpl implements IGoblinListService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;

    @Override
    public void getList() {

    }

    @Override
    public ResponseDto<GoblinListDetailsVo> getDetails(String listId) {
        GoblinListDetailsVo vo = redisUtils.getGoblinListDetailsVo(listId);
        if (vo == null || !vo.getUid().equals(CurrentUtil.getCurrentUid())) {
            return ResponseDto.failure("信息错误");
        }
        for (GoblinListDetailsItemVo item:vo.getItemVo()) {
            GoblinGoodsSkuInfoVo skuVo = redisUtils.getGoodsSkuInfoVo(item.getSkuId());
            item.setSkuName(skuVo.getName());
            if (skuVo.getUnbox().equals("0")) {
                item.setSurplusStock(redisUtils.getSkuStock(null, item.getSkuId()));
                item.setStock(skuVo.getSkuStock());
            } else {
                List<String> skuIdList = redisUtils.getGoodsInfoVo(item.getSpuId()).getSkuIdList();
                int surplusStock = 0;
                int stock = 0;
                for (String skuIdItem : skuIdList) {// 盲盒计算所有sku库存总数
                    if (skuIdItem.equals(item.getSkuId())) {// 过滤自己
                        stock+=skuVo.getSkuStock();
                        continue;
                    }
                    GoblinGoodsSkuInfoVo itemVo = redisUtils.getGoodsSkuInfoVo(skuIdItem);
                    surplusStock += redisUtils.getSkuAllStatusStock(itemVo);
                    stock+=itemVo.getSkuStock();
                }
                item.setSurplusStock(surplusStock);
                item.setStock(stock);
            }
        }
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> create(GoblinListCreateParam param) {
        GoblinListDetailsVo vo = GoblinListDetailsVo.getNew();
        List<GoblinListDetailsItemVo> voItemList = ObjectUtil.goblinListDetailsItemVoArrayList();
        vo.setListId(IDGenerator.nextTimeId2());
        vo.setUid(CurrentUtil.getCurrentUid());
        vo.setName(param.getName());
        vo.setAdvanceMin(param.getAdvanceMin());
        vo.setWhiteType(param.getWhiteType());
        //判断 白名单类型
        if (param.getWhiteType().equals(1)) {//需要xls文件
            if (param.getWhiteUrl() == null || param.getWhiteUrl().equals("")) {
                return ResponseDto.failure("未上传指定用户文件");
            }
            vo.setWhiteUrl(param.getWhiteUrl());
        } else {//不需要xls文件
            vo.setWhiteUrl("");
        }
        vo.setBlackUrl(param.getBlackUrl() == null ? "" : param.getBlackUrl());
        for (GoblinListCreateItemParam item : param.getItemParams()) {
            GoblinListDetailsItemVo itemVo = GoblinListDetailsItemVo.getNew();
            itemVo.setSkuId(item.getSkuId());
            itemVo.setSpuId(item.getSpuId());
        }
        vo.setItemVo(voItemList);
        redisUtils.setGoblinListDetailsVo(vo);
        mongoUtils.insertGoblinListDetailsVo(vo);
        //todo sql入库/添加白名单/添加黑名单
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> update(GoblinListUpdateParam param) {
        String whiteUrl = "";
        String blackUrl = "";
        GoblinListDetailsVo vo = redisUtils.getGoblinListDetailsVo(param.getListId());
        if (vo == null || !vo.getUid().equals(CurrentUtil.getCurrentUid())) {
            return ResponseDto.failure("信息错误");
        }
        whiteUrl = vo.getWhiteUrl();
        blackUrl = vo.getBlackUrl();
        //判断 白名单类型
        vo.setWhiteType(param.getWhiteType());
        if (param.getWhiteType().equals(1)) {//需要xls文件
            if (param.getWhiteUrl() == null || param.getWhiteUrl().equals("")) {
                return ResponseDto.failure("未上传指定用户文件");
            }
            vo.setWhiteUrl(param.getWhiteUrl());
        } else {//不需要xls文件
            vo.setWhiteUrl("");
        }
        vo.setBlackUrl(param.getBlackUrl() == null ? "" : param.getBlackUrl());
        redisUtils.setGoblinListDetailsVo(vo);
        mongoUtils.changeGoblinListDetailsVo(param.getListId(), vo);
        //todo sql入库/添加白名单/添加黑名单
        return ResponseDto.success();
    }
}
