package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamDisposedVo", description = "想去信息")
@Data
public class AdamDisposedVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3222644230886542725L;
    @ApiModelProperty(position = 11, required = true, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 12, required = true, value = "内容类型")
    private String type;
    @ApiModelProperty(position = 13, required = true, value = "标记时间")
    private String createdAt;
    @ApiModelProperty(position = 14, required = true, value = "展示信息")
    private PerformanceVo contentInfo;

    private static final AdamDisposedVo obj = new AdamDisposedVo();

    public static AdamDisposedVo getNew() {
        try {
            return (AdamDisposedVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamDisposedVo();
        }
    }
}
