package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.dto.vo.AdamCollectBaseVo;
import com.liquidnet.service.adam.dto.vo.AdamCollectVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamCollection;
import com.liquidnet.service.adam.mapper.AdamCollectionMapper;
import com.liquidnet.service.adam.service.IAdamCollectionService;
import com.liquidnet.service.adam.service.IAdamUserService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.kylin.api.FeignKylinPerformanceClient;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 收藏 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Slf4j
@Service
public class AdamCollectionServiceImpl extends ServiceImpl<AdamCollectionMapper, AdamCollection> implements IAdamCollectionService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    IAdamUserService adamUserService;


    /* ---------------- 外部服务API ---------------- */
    @Autowired
    FeignKylinPerformanceClient kylinPerformanceClient;

    @Override
    public void add(AdamCollectBaseVo collectionVo) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        collectionVo.setState(1);
        collectionVo.setCreatedAt(nowStr);

        AdamUserInfoVo userInfoVo = adamUserService.queryByUid(collectionVo.getUid());
        collectionVo.setAvatar(userInfoVo.getAvatar());
        collectionVo.setNickname(userInfoVo.getNickname());
        collectionVo.setSex(userInfoVo.getSex());

        mongoTemplate.insert(collectionVo, AdamCollectBaseVo.class.getSimpleName());

        // TODO: 2021/5/19 sql to mq

    }

    @Override
    public AdamCollectBaseVo query(String uid, String type, String contentId) {
//        AdamCollectionVo vo = (AdamCollectionVo) redisUtil.hget(AdamRedisConst.INFO_COLLECT.concat(uid), type + contentId);
//        if (null == vo) {
//            vo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("type").is(type).and("contentId").is(contentId)),
//                    AdamCollectionVo.class, AdamCollectionVo.class.getSimpleName());
//
//            if (null != vo) redisUtil.hset(AdamRedisConst.INFO_COLLECT.concat(uid), type + contentId, vo);
//        }
        return mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                        .and("contentId").is(contentId).and("state").is(1)),
                AdamCollectBaseVo.class, AdamCollectBaseVo.class.getSimpleName());
    }

    @Override
    public void del(String uid, String type, String contentId) {
        AdamCollectBaseVo delVo = AdamCollectBaseVo.getNew();
        delVo.setState(2);
        delVo.setUpdatedAt(DateUtil.getNowTime());
        mongoTemplate.getCollection(AdamCollectBaseVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                        .and("contentId").is(contentId).and("state").is(1)).getQueryObject(),
                new BasicDBObject("$set", mongoConverter.convertToMongoType(delVo)));
    }

    @Override
    public boolean queryState(String uid, String type, String contentId) {
        long count = mongoTemplate.count(Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                .and("contentId").is(contentId).and("state").is(1)), AdamCollectBaseVo.class.getSimpleName());
        return count > 0;
    }

    @Override
    public PageInfo<AdamCollectVo> queryPage(String uid, String type, int pageNo, int pageSize) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("type").is(type));

        long count = mongoTemplate.count(query, AdamCollectBaseVo.class.getSimpleName());

        PageInfo<AdamCollectVo> voPageInfo = null;
        if (count > 0) {
            Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "createdAt"));

            query.with(pageable);

            List<AdamCollectVo> collectVoList = mongoTemplate.find(query, AdamCollectVo.class, AdamCollectBaseVo.class.getSimpleName());

            try {
                String[] contentIds = collectVoList.stream().map(AdamCollectVo::getContentId).toArray(a -> new String[collectVoList.size()]);

                ResponseDto<List<PerformanceVo>> performanceVoListDto = kylinPerformanceClient.performanceList(contentIds);

                if (performanceVoListDto.isSuccess()) {
                    List<PerformanceVo> performanceVoList = performanceVoListDto.getData();

                    collectVoList.forEach(v -> {
                        performanceVoList.forEach(vl -> {
                            if (vl.getPerformancesId().equals(v.getContentId())) {
                                v.setContentInfo(vl);
                            }
                        });
                    });
                } else {
                    log.info("Failed:{}.API.performanceList(...) for AdamCollection:{}", kylinPerformanceClient.getClass().getSimpleName(), performanceVoListDto.toJson());
                }
            } catch (Exception e) {
                log.error("Exception:{}.API.performanceList(...) for AdamCollection", kylinPerformanceClient.getClass().getSimpleName(), e);
            }
            voPageInfo = PageInfo.of(collectVoList);
            voPageInfo.setTotal(count);
        } else {
            voPageInfo = new PageInfo<>();
        }

        return voPageInfo;
    }
}
