package com.liquidnet.service.consumer.service.processor;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.service.IBaseDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @Resource
    IBaseDao baseDao;

//    @RabbitListener(bindings = @QueueBinding(
//            exchange = @Exchange("queue.sql"),
//            key = "rk",
//            value = @Queue("queue.sql.main")
//    ))
//    @RabbitHandler
//    public void consumerSql(Message message) {
//        log.info("consumer sql:{}", message);
//    }

    @RabbitListener(queues = MQConst.QUEUES_SQL_MAIN)
    public void consumerSql(String msg) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(msg, SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("batchSqls result of execution:{}", rstBatchSqls);
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }
}
