package com.liquidnet.service.executor.main.handler;

import com.alibaba.fastjson.JSON;
import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public ReturnT<String> execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@Component
public class ExecutorMainDemoHandler {
    private static final Logger log = LoggerFactory.getLogger(ExecutorMainDemoHandler.class);
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @XxlJob(value = "sev-sequence:mainDemoJobHandler")
    public ReturnT<String> mainDemoJobHandler(String param) {
        XxlJobLogger.log("liquidnet.mainDemoJobHandler");
        Long test = feignSequenceClient.nextId();
        XxlJobLogger.log("test : " + test);
        Long[] tests = feignSequenceClient.nextId(2);
        XxlJobLogger.log("tests: " + JSON.toJSONString(tests));
        Long nextIncrId = feignSequenceClient.nextIncrId("SEQ_WL_N01_1784");
        XxlJobLogger.log("incrid:" + nextIncrId);
        return ReturnT.SUCCESS;
    }
}
