package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesTicketCreatePartnerVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class PerformanceStep2Param implements Serializable {

    @ApiModelProperty(value = "演出id", example = "")
    @NotNull(message = "不能为空")
    private String performancesId;

    @ApiModelProperty(value = "是否实名", example = "0")
    @NotNull(message = "不能为空")
    private Integer isTrueName;

    @ApiModelProperty(value = "限购数量 0为不限购", example = "0")
    @NotNull(message = "不能为空")
    private Integer limitCount;

    @ApiModelProperty(value = "是否提交 1提交 0不提交(不验证参数)", example = "0")
    @NotNull(message = "不能为空")
    private Integer isSubmit;

    @ApiModelProperty(value = "场次数据",hidden = true)
    private List<TicketTimesTicketCreatePartnerVo> ticketTimes;
}
