package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@ApiModel(value = "GoblinNftOrderPayAgainParam", description = "再次支付所需参数")
@Data
public class GoblinNftOrderPayAgainParam {

    @ApiModelProperty(value = "openId")
    private String openId;

    @ApiModelProperty(value = "订单id")
    @NotNull(message = "订单ID不能为空")
    private String orderId;

    @ApiModelProperty(value = "支付类型")
    @NotNull(message = "支付类型不能为空")
    private String payType;

    @ApiModelProperty(value = "支付来源")
    @NotNull(message = "支付来源不能为空")
    private String deviceFrom;

    @ApiModelProperty(value = "showUrl")
    private String showUrl;

    @ApiModelProperty(value = "returnUrl")
    private String returnUrl;

}
