package com.liquidnet.common.mq.util;

import com.liquidnet.common.mq.constant.GlobalConstant;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:guo_xp@163.com">guoxinpeng</a>
 * @version 1.0 2016/11/23 18:58
 * @projectname new-pay
 * @packname com.liquidnet.service.config.util
 */
public class HttpUtil {
  private static PoolingHttpClientConnectionManager cm;
  private static String EMPTY_STR = "";
  private static String UTF_8 = GlobalConstant.ENCODING_UTF8;

  private static void init() {
    if (cm == null) {
      cm = new PoolingHttpClientConnectionManager();
      cm.setMaxTotal(50);// 整个连接池最大连接数
      cm.setDefaultMaxPerRoute(5);// 每路由最大连接数，默认值是2
    }
  }

  /**
   * 通过连接池获取HttpClient
   *
   * @return
   */
  private static CloseableHttpClient getHttpClient() {
    init();
    return HttpClients.custom().setConnectionManager(cm).build();
  }

  /**
   * @param url
   * @return
   */
  public static String httpGetRequest(String url) {
    HttpGet httpGet = new HttpGet(url);
    return getResult(httpGet);
  }

  public static String httpGetRequest(String url, Map<String, Object> params) throws URISyntaxException {
    URIBuilder ub = new URIBuilder();
    ub.setPath(url);

    ArrayList<NameValuePair> pairs = covertParams2NVPS(params);
    ub.setParameters(pairs);

    HttpGet httpGet = new HttpGet(ub.build());
    return getResult(httpGet);
  }

  public static String httpGetRequest(String url, Map<String, Object> headers, Map<String, Object> params) throws URISyntaxException {
    URIBuilder ub = new URIBuilder();
    ub.setPath(url);

    ArrayList<NameValuePair> pairs = covertParams2NVPS(params);
    ub.setParameters(pairs);

    HttpGet httpGet = new HttpGet(ub.build());
    for (Map.Entry<String, Object> param : headers.entrySet()) {
      httpGet.addHeader(param.getKey(), String.valueOf(param.getValue()));
    }
    return getResult(httpGet);
  }

  public static String httpPostRequest(String url) {
    HttpPost httpPost = new HttpPost(url);
    return getResult(httpPost);
  }
  public static String httpPostRequest(String url,Object obj,String dataType) throws UnsupportedEncodingException {
    switch (dataType){
      case GlobalConstant.JSON:
        return httpPostRequest(url,(Map<String, Object>)obj);
      case GlobalConstant.XML:
        return httpPostRequest(url,obj);
      default:
        return httpPostRequest(url,(Map<String, Object>)obj);
    }
  }
  public static String httpPostRequest(String url, Map<String, Object> params) throws UnsupportedEncodingException {
    HttpPost httpPost = new HttpPost(url);
    ArrayList<NameValuePair> pairs = covertParams2NVPS(params);
    httpPost.setEntity(new UrlEncodedFormEntity(pairs, UTF_8));
    return getResult(httpPost);
  }

  public static String httpPostRequest(String url, Map<String, Object> headers, Map<String, Object> params) throws UnsupportedEncodingException {
    HttpPost httpPost = new HttpPost(url);

    for (Map.Entry<String, Object> param : headers.entrySet()) {
      httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
    }

    ArrayList<NameValuePair> pairs = covertParams2NVPS(params);
    httpPost.setEntity(new UrlEncodedFormEntity(pairs, UTF_8));

    return getResult(httpPost);
  }
  public static String httpPostRequest(String url, Object objXml) throws UnsupportedEncodingException {
    HttpPost httpPost = new HttpPost(url);
    String xml = JAXBUtil.convertToXml(objXml);
    StringEntity stringEntity = new StringEntity(xml, ContentType.APPLICATION_XML);
    httpPost.setEntity(stringEntity);
    return getResult(httpPost);
  }

  private static ArrayList<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
    ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
    for (Map.Entry<String, Object> param : params.entrySet()) {
      pairs.add(new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
    }

    return pairs;
  }

  /**
   * 处理Http请求
   *
   * @param request
   * @return
   */
  private static String getResult(HttpRequestBase request) {
    // CloseableHttpClient httpClient = HttpClients.createDefault();
    CloseableHttpClient httpClient = getHttpClient();
    try {
      CloseableHttpResponse response = httpClient.execute(request);
      // response.getStatusLine().getStatusCode();
      HttpEntity entity = response.getEntity();
      if (entity != null) {
        // long len = entity.getContentLength();// -1 表示长度未知
        String result = EntityUtils.toString(entity);
        response.close();
        // httpClient.close();
        return result;
      }
    } catch (ClientProtocolException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    } finally {

    }

    return EMPTY_STR;
  }


  public static void main(String[] args) {
//    String result = httpGetRequest("http://10.0.129.161:9080/globalId?code=YGOL&num=2");
//    JSONObject jo = JSONObject.parseObject(result);
//    System.out.println(result);
    Map<String,Object> header = new HashMap<String,Object>();
    Map<String,Object> param = new HashMap<String,Object>();
    param.put("globalId","002");
    param.put("userName","张三");
    param.put("customerIdType","ID");
    param.put("idCardNo","111111");
    param.put("serialNo","003");
    param.put("orderNo ","004");
    param.put("requestType","CREATE_ACCOUNT");
    param.put("applicationId ","YGONLINE");
    param.put("accountType ","CREDIT");

//    try {
////      String result = httpPostRequest("http://10.0.129.120:13180/rest/customer/add",);
////      System.out.print(result);
//    } catch (UnsupportedEncodingException e) {
//      e.printStackTrace();
//    }

  }
}
