package com.liquidnet.service.bank.currencycloud.service;

import com.currencycloud.client.model.Transactions;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcTransactionQuery;
import com.liquidnet.service.bank.currencycloud.entity.BankCcTransaction;

/**
 * account service
 *
 * @author LiChen
 * @date 2020/10/12 2:46 下午
 */
public interface IBankCcTransactionService {

    int insertOrUpdate(BankCcTransaction bankCcTransaction);

    /**
     * find transactions
     *
     * @param contactId   contactId为空,默认查询的是cc 二级账户的交易信息
     * @param transaction 查询条件
     */
    ResponseDto<Transactions> findTransactions(BankCcTransactionQuery query);

    /**
     * 检索transactions
     */
    BankResultDto<BankCcTransaction> retrieveTransaction(String transactionId, String contactId);

}
